import pandas as pd
import yfinance as yf
df_stocks = pd.DataFrame()
tickers = ['MSFT','ORCL','AMZN']
for ticker in tickers:
  tkr = yf.Ticker(ticker)
  hist = tkr.history(period='7d')
  hist['Symbol']=ticker
  df_stocks = df_stocks.append(hist[['Symbol', 'Close']].rename(columns={'Close': 'Price'}))

stocks_to_db = df_stocks[['Symbol', 'Price']].reset_index().rename(columns={'Date': 'Dt'}).round(2)
data = list(stocks_to_db.itertuples(index=False, name=None))
import cx_Oracle
try:
  conn = cx_Oracle.connect("usr", "pswd", "localhost/orcl")
  cursor = conn.cursor()
  #defining the query
  query_add_stocks = """INSERT INTO stocks (dt, symbol, price) 
                      VALUES (TO_DATE(:1, 'DD-MM-YYYY'), :2, :3)"""
  #inserting the stock rows
  cursor.executemany(query_add_stocks, data)
  conn.commit()
except cx_Oracle.DatabaseError as exc:
  err = exc.args
  print("Oracle-Error-Code:", err.code)
  print("Oracle-Error-Message:", err.message)
finally:
  cursor.close()
