Rem dba_over_network.sql
Rem
Rem Copyright  2020, Oracle and/or its affiliates. All rights reserved. This script is provided for educational purposes only and are not intended for production use, and the contents hereof are subject to change without notice. This script is not warranted to be error-free, nor subject to any other warranties or conditions, whether expressed orally or implied in law, including implied warranties and conditions of merchantability or fitness for a particular purpose. We specifically disclaim any liability with respect to this script, and no contractual obligations are formed either directly or indirectly by this script. 
Rem
Rem    NAME
Rem      dba_over_network.sql - Used to mimic DBA activity over network and see how the traffic is processed by the Firewall based on the policy
Rem
Rem    DESCRIPTION
Rem      This scripts  mimics DBA activity over network and see how the traffic is processed by the Firewall based on the policy
Rem
Rem    NOTES
Rem      You will need to enter the sys password as parameter when prompted
Rem       Run this script on the database instance where HCM user schema is configured connected through Firewall IP address and proxy port
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    adhanara    07/28/20 - Created
Rem


/*************************************************************************************************/
/* DBA activity over the network */

--Enter the SYS password
def PW = &SYSPASSWORD
def HCM_USER = HCM

def EMP_ID = 181
def LOC_ID = 2900
def DEPT_ID = 80

/*************************************************************************************************/
/* BEGIN: DBA Workload */

--dba_debra@example.com
--dba_harvey@example.com
--dba_charles@example.com

select sysdate from dual;
/* BEGIN: DBA_Queries1 */

select null as "DBA_Queries1" from dual;

connect "dba_debra@example.com"/&PW

show user;

--
-- Gather table statistics as an example of an action a DBA might take. 
--
exec dbms_stats.gather_table_stats('&HCM_USER','EMPLOYEES');

/* END: DBA_Queries1 */

/*************************************************************************************************/

/* BEGIN: DBA_Queries2 */

select null as "DBA_Queries2 :EXPECTED TO ERROR" from dual;


connect "dba_charles@example.com"/&PW
show user;

--
-- Switch logfile is an example of an action a DBA might take. 

alter system switch logfile;  

/* END: DBA_Queries2 */

/*************************************************************************************************/

/* BEGIN: DBA_Queries3 */

select null as "DBA_Queries3" from dual;

--
-- Basic queries as an example of an action a DBA might take. 
--
connect "dba_harvey@example.com"/&PW
show user;

select count(*) From v$session;
select * from gv$instance;
select count(*) from v$process;
select sessions_max, sessions_current, sessions_highwater, users_max from v$license;

select b.paddr , b.name nme, b.description descr, to_char(b.error) cerror from  v$bgprocess b, v$process p where  b.paddr = p.addr;

select sequence#, group#, first_change#, first_time, archived, bytes from v$log order by sequence#, group#;

select count(*)
from sys.dba_segments a
where a.tablespace_name not like 'T%MP%'
   and nvl(a.next_extent,a.initial_extent) * 1 > 
    (select max(b.bytes) from dba_free_space b where a.tablespace_name = b.tablespace_name);


SELECT count(*)
FROM (SELECT tablespace_name, SUM (blocks) ublocks
        FROM dba_segments
        GROUP BY tablespace_name) s,
     (SELECT tablespace_name, SUM (blocks) fblocks
        FROM dba_free_space
        GROUP BY tablespace_name) f,
     (SELECT tablespace_name, SUM(blocks) ablocks
        FROM dba_data_files
        GROUP BY tablespace_name) a
WHERE s.tablespace_name = f.tablespace_name and
      s.tablespace_name = a.tablespace_name and
      s.tablespace_name not in ('SYSTEM','SYSAUX','TOOLS','UNDO01') and
      ((s.ublocks/a.ablocks)*100) > 50;

--
-- Some of the queries as DBA_DEBRA might fail. 
-- This is acceptable behavior.
--
connect "dba_debra@example.com"/&PW
show user;

select count(*)
from    v$sysstat a, v$statname b
where   a.statistic# = b.statistic#;

select sum(getmisses)/sum(gets)*100 dict_cache from v$rowcache;

select sum(reloads)/sum(pins) *100 lib_cache from v$librarycache;

connect "dba_harvey@example.com"/&PW
show user;

select  count(*)
from   v$sysstat
where  name in ('sorts (memory)', 'sorts (disk)','sorts (rows)');

select   count(*)
from	v$sysstat
where   name = 'free buffer waits';

SELECT  count(*)
FROM	v$system_event SE,
	(SELECT SUM(time_waited) total_waittime FROM v$system_event
	WHERE wait_class NOT IN ('Idle','Network'))
WHERE	total_waits > 0
	AND time_waited > 1000
	AND wait_class NOT IN ('Idle','Network');


/* END: DBA_Queries3 */

/*************************************************************************************************/

/* BEGIN: DBA_Queries4 */

select null as "DBA_Queries4" from dual;

-- 
-- Rebuilding indexes is an example of action a DBA might take

-- 
connect "dba_charles@example.com"/&PW
show user;

begin 
for x in (select owner, index_name from dba_indexes where owner = '&HCM_USER') loop

begin
dbms_output.put_line('rebuilding '||x.owner||'.'||x.index_name||'...');
execute immediate 'alter index '||x.owner||'.'||x.index_name||' rebuild';
exception when others then
 null;
end;

end loop;
end;
/
--Charles DBA granting excessive privileges to Employee Sophie

grant select on &HCM_USER..JOB_HISTORY to "sophie@example.com";
grant select on &HCM_USER..LOCATIONS to "sophie@example.com";

--Charles DBA granting excessive privileges to Employee Lucas
grant insert on &HCM_USER..EMPLOYEES to "lucas@example.com";
/* END: DBA_Queries4 */


/*************************************************************************************************/

/* BEGIN: DBA_Work5 */

select null as "DBA_Work5" from dual;

--
-- Basic queries as an example of an action a DBA or end-user might take. 
-- ALTER SYSTEM commands might fail in a PDB or ADB.  This is acceptable. 
--
connect "dba_debra@example.com"/&PW
show user; 

show parameter processes
alter system set processes = 505 scope=memory;--EXPECTED TO ERROR

select * from v$parameter where name like '%optimizer_index%';
alter system set optimizer_index_cost_adj = 85 scope=memory;

--
-- Basic actions a DBA or end-user might take. 
--
alter table &HCM_USER..EMPLOYEES modify phone_number varchar2(20); 

--
-- Basic actions a DBA or end-user might take. 
--
grant select any table to scott;
revoke select any table from scott;
grant select any table to approle2;

/* END: DBA_Work5 */

/*************************************************************************************************/


/* BEGIN: DBA_Work6 */

select null as "DBA_Work6" from dual;

connect "dba_harvey@example.com"/&PW

-- Typical DBA actions. 
select * from dba_users where username = 'lucas@example.com';
select * from dba_role_privs where grantee = 'lucas@example.com';
select * from dba_tab_privs where grantee = 'lucas@example.com';

-- Grant might fail because DBA_HARVEY has not been granted RESOURCE "with admin" option
-- Acceptable failure. 
grant RESOURCE to "lucas@example.com";

-- this grant may fail. DBA_HARVEY does not have the ability to grant this privilege. This is acceptable. 
grant UNLIMITED TABLESPACE to "lucas@example.com";

-- Typical DBA actions. Do they get audited? Is this acceptable behavior?
select * from dba_users where username = 'jron@example.com';
select * from dba_role_privs where grantee = 'jron@example.com';
select * from dba_tab_privs where grantee = 'jron@example.com';

/* END: DBA_Work6 */

/*************************************************************************************************/

/* BEGIN: Malicious Work7 by DBA */

select null as "MaliciousWork7" from dual;

-- 
-- This section is intentionally malicious. Someone has stolen Charles' credentials and uses it update the salary of employee henrywil@example.com +samkirk@example.com
-- This memics an attacker probing the database with stolen credentials. There may be a lot of failures in here.
-- 
connect "dba_charles@example.com"/&PW
show user;

select count(*) From dba_objects;
select count(*) from user_objects;

select count(*) from &HCM_USER..EMPLOYEES;

select USERNAME, LAST_INS_CLAIM from &HCM_USER..SUPPLEMENTAL_DATA;

select department_name from &HCM_USER..DEPARTMENTS order by 1;

select JOB_TITLE, MIN_SALARY, MAX_SALARY from &HCM_USER..jobs order by 1;

select * from &HCM_USER..emp_extended where rownum < 10 order by 1;

select * from &HCM_USER..JOBS;
SELECT * from &HCM_USER..JOB_HISTORY;
SELECT * from &HCM_USER..LOCATIONS;
--select all the employees ordered by department showing their salary with Full Outer Join
select e.EMPLOYEE_ID, e.EMAIL, e.SALARY, d.DEPARTMENT_NAME from &HCM_USER..EMPLOYEES e FULL OUTER JOIN &HCM_USER..DEPARTMENTS d  ON  e.department_id=d.department_id order by d.department_name;
update &HCM_USER..EMPLOYEES set SALARY=99999 where email = 'henrywil@example.com';
--Return all employees regardless of their managers existence:
SELECT e.email as EMPLOYEE, e.salary as EMP_SALARY, m.email as MANAGER, m.salary as MGR_SALARY FROM &HCM_USER..EMPLOYEES e, &HCM_USER..EMPLOYEES m WHERE e.manager_id = m.employee_id(+);
--select all employees whose commission_pct is greater than expected fraction of salary
select employee_id,first_name,last_name, salary, commission_pct, commission_pct/(salary/(365*100))  from &HCM_USER..EMPLOYEES where COMMISSION_PCT is not null  and  commission_pct/(salary/(365*100)) >1;

-- Average salary per department
SELECT DEPARTMENT_ID, AVG(SALARY) FROM &HCM_USER..EMPLOYEES GROUP BY(DEPARTMENT_ID);

-- Employee records whose salary is greater than average salary of their department
select e.*
from (select e.*, avg(salary) over (partition by department_id) as avgsalary
      from &HCM_USER..EMPLOYEES e
     ) e
where e.salary > e.avgsalary;

-- Employee records whose salary is lesser than average salary of their department
select e.*
from (select e.*, avg(salary) over (partition by department_id) as avgsalary
      from &HCM_USER..EMPLOYEES e
     ) e
where e.salary < e.avgsalary;

--select * from &HCM_USER..EMPLOYEES where email = 'henrywil@example.com';
update &HCM_USER..EMPLOYEES set SALARY=23999 where EMAIL='samkirk@example.com';
select * from &HCM_USER..EMPLOYEES where email = 'samkirk@example.com';

commit;

--Then tries to wipe out the audit history---
delete from unified_audit_trail;
truncate table audsys.aud$unified;


/* END: MaliciousWork7 */

/*************************************************************************************************/

/* BEGIN: MaliciousWork8 */

select null as "MaliciousWork8" from dual;

-- 
-- This section is intentionally malicious. 
-- This memics an attacker probing the database with stolen credentials. There may be a lot of failures in here.
-- 
connect &HCM_USER/&PW
show user;

NOAUDIT ALL;

create user APP_TEST identified by Oracle123;    

show user;

SELECT * from &HCM_USER..EMPLOYEES;
SELECT * from &HCM_USER..EMP_EXTENDED;
SELECT * from &HCM_USER..JOBS;
SELECT * from &HCM_USER..JOB_HISTORY;
SELECT * from &HCM_USER..LOCATIONS;

update &HCM_USER..EMPLOYEES set SALARY=14000 where EMAIL='samkirk@example.com';
commit;

select null as "EXPECTED TO ERROR" from dual;
grant DBA to &HCM_USER;

alter system set utl_file_dir = '/tmp' scope=memory;      
/* END: MaliciousWork8 */

/*************************************************************************************************/

/* BEGIN: MaliciousWork9 */

select null as "MaliciousWork11 - EXPECTED TO ERROR" from dual;

-- 
-- This section is intentionally malicious. 
-- This memics an attacker probing the database with stolen credentials. There may be a lot of failures in here.

connect &HCM_USER/&PW
show user;

select * from dba_users;

select * from sys.link$; 

/* END: MaliciousWork9 */

/*************************************************************************************************/

/* BEGIN: MaliciousWork10 */

select null as "MaliciousWork10" from dual;

-- 
-- This section is intentionally malicious. 
-- This memics an attacker probing the database with stolen credentials. There may be a lot of failures in here.

-- 
connect &HCM_USER/&PW
show user;

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID from &HCM_USER..EMPLOYEES where employee_id = &EMP_ID order by last_name;

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID from &HCM_USER..EMPLOYEES where department_id = &DEPT_ID order by last_name;

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, SALARY,COMMISSION_PCT,MANAGER_ID from &HCM_USER..EMPLOYEES where department_id = &DEPT_ID order by manager_id;

select * from &HCM_USER..emp_extended where employee_id = &EMP_ID;

select * from &HCM_USER..locations where location_id = &LOC_ID;

select LAST_NAME, FIRST_NAME, EMAIL from &HCM_USER..employees where manager_id = &EMP_ID order by 2;

/* END: MaliciousWork10 */

/*************************************************************************************************/


/* BEGIN: DBAWork-11 */

select null as " DBAWork-11- ALL QUERIES EXPECTED TO ERROR" from dual;

connect PDBADMIN/Welcome_1
show user; 


drop profile POWERUSERS;
create profile POWERUSERS limit 
   FAILED_LOGIN_ATTEMPTS 5
   PASSWORD_LIFE_TIME 60
   PASSWORD_REUSE_TIME 60
   PASSWORD_REUSE_MAX 5
   PASSWORD_VERIFY_FUNCTION null
   PASSWORD_LOCK_TIME 1/24
   PASSWORD_GRACE_TIME 10;

ALTER PROFILE default LIMIT 
	FAILED_LOGIN_ATTEMPTS UNLIMITED 
	PASSWORD_GRACE_TIME UNLIMITED  
	PASSWORD_LIFE_TIME UNLIMITED
	PASSWORD_LOCK_TIME UNLIMITED;

-- 
-- You cannot modify profiles on ADB instances. That is acceptable.
ALTER PROFILE APP_PROFILE LIMIT 
	FAILED_LOGIN_ATTEMPTS UNLIMITED 
	PASSWORD_GRACE_TIME UNLIMITED  
	PASSWORD_LIFE_TIME UNLIMITED
	PASSWORD_LOCK_TIME UNLIMITED;

drop user MALFOY cascade;
drop user VOLDEMORT cascade;
drop user GRINDELWALD cascade;
drop user WEASLEY;
drop user LESTRANGE cascade;
drop user SKEETER cascade;
drop user APP_USER cascade;

-- drop and recreate sample users with default passwords (no objects as not needed)
drop user ADAMS cascade;
drop user BLAKE cascade;
drop user CLARK cascade;
drop user HR cascade;

-- This will not work on ADB because of password requirements. That is acceptable.
create user ADAMS identified by wood;
create user BLAKE identified by paper;
create user CLARK identified by cloth;
create user HR identified by hr;
create user IX identified by ix;
create user JONES identified by steel;
create user OE identified by oe;
create user PM identified by pm;
create user SH identified by sh;
create user SCOTT identified by tiger;

-- 18c schema only account
drop user NOAUTH cascade;
create user NOAUTH no authentication;

create user MALFOY identified by &PW;
create user LESTRANGE identified by &PW;
create user SKEETER identified by &PW;
alter user PU_PETE identified by &PW profile POWERUSERS;
create user VOLDEMORT identified by &PW profile POWERUSERS password EXPIRE;
create user GRINDELWALD identified by &PW;
-- Will get privileges to be flagged as Non-Privileged, Medium Risk
create user WEASLEY identified by &PW;
-- User APPX will show up on User Assessment as "Schema" and with Status "Expired & Locked"
create user APPX identified by &PW account lock password expire;
create user APP_USER identified by &PW profile APP_PROFILE;

grant connect to DBA_HARVEY, MALFOY, PU_PETE, APP_USER, LESTRANGE, SKEETER, VOLDEMORT;
grant AUDIT_ADMIN to SKEETER;
grant SYSDBA to LESTRANGE;
grant SYSDG to MALFOY;
grant SYSKM to VOLDEMORT;
grant DBA to PUBLIC;
grant DBA to PDBADMIN;
grant DBA to MALFOY;
grant DBA to PU_PETE;
grant DBA to DBA_DEBRA;


grant CAPTURE_ADMIN to DBA_DEBRA, PDBADMIN;
grant SELECT ANY TABLE to VOLDEMORT;
grant ALTER DATABASE LINK to WEASLEY;
grant CREATE ANY OPERATOR to WEASLEY;
grant ALTER RESOURCE COST to WEASLEY;
grant CREATE ROLLBACK SEGMENT to WEASLEY;
grant SELECT ANY TABLE to SCOTT;
grant UPDATE ANY TABLE to SCOTT;
grant EXPORT FULL DATABASE to SCOTT;
grant SELECT ANY TABLE to HCM1;
grant UPDATE ANY TABLE to HCM1;
grant DELETE ANY TABLE to HCM2;
create directory BENIGN as '/tmp';
create directory TRUSTME as '/tmp';

-- To raise 'Directory Objects' finding to High Risk
grant write, execute on directory BENIGN to GRINDELWALD;

-- To highlight indirect privileges
drop role approle1;
drop role approle2;
drop role approle3;
create role approle1; 
create role approle2;
create role approle3;
grant create session to approle1;
grant resource to approle1;
grant select any table to approle2;
grant dba to approle3;
grant approle3 to approle2;
grant approle2 to approle1;
grant approle1 to GRINDELWALD;
grant EXECUTE on SYS.DBMS_BACKUP_RESTORE to GRINDELWALD;

-- To turn "Access to Password Verifier Tables" Evaluate
grant select on sys.link$ to GRINDELWALD;

drop directory BENIGN;
drop directory TRUSTME;

connect APP_USER/&PW

select * from &HCM_USER..SUPPLEMENTAL_DATA;
update &HCM_USER..EMPLOYEES set SALARY=23999 where EMAIL='samkirk@example.com';

/* END:  DBAWork-11 */

/*************************************************************************************************/


/* BEGIN: RegularWork12 */

select null as "RegularWork12" from dual;

-- 
-- This section is is an example of normal DBA, Application, End-user activity.
-- These queries should return successful. No queries should fail. 
--
connect &HCM_USER/&PW
show user;
 
select count(*) From user_tables;
select count(*) from user_objects;

select count(*) from &HCM_USER..EMPLOYEES;

select department_name from &HCM_USER..DEPARTMENTS order by 1;

select JOB_TITLE, MIN_SALARY, MAX_SALARY from &HCM_USER..jobs order by 1;

select * from &HCM_USER..emp_extended where rownum < 10 order by 1;

/* END: RegularWork12 */

/*************************************************************************************************/



/* BEGIN: MaliciousHRWork13 */

--DBA accidentally grants extra privileges to hr_jim@example.com and he can do updates on JOBS/REGIONS from the apps. 
select null as "MaliciousHRWork13" from dual;

connect "dba_debra@example.com"/Welcome_1
show user;
GRANT ALL ON &HCM_USER..JOBS to "hr_jim@example.com";




 /* END: MaliciousHRWork13 */
 /*************************************************************************************************/

/* BEGIN: BadLogin14 */

select null as "BadLogin18" from dual;

--
-- Intentionally causing failed logins to show up in the Audit Trails

--
connect "dba_debra@example.com"/badpass
connect "dba_harvey@example.com"/badpass
connect &HCM_USER/badpass
connect &HCM_USER/badpass
connect system/badpass
connect "hr_lan@example.com"/badpass
connect sys/badpass

/* END: BadLogin14 */

 /*************************************************************************************************/


