/**
* employee.java
*
* Copyright  2020, Oracle and/or its affiliates. All rights reserved. This script is provided for educational purposes only and are not intended for production use, and the contents hereof are subject to change without notice. This script is not warranted to be error-free, nor subject to any other warranties or conditions, whether expressed orally or implied in law, including implied warranties and conditions of merchantability or fitness for a particular purpose. We specifically disclaim any liability with respect to this script, and no contractual obligations are formed either directly or indirectly by this script. 
*
*   NAME
*      employee.java - Sample java thin client used by application tier to access the database protected by Database Firewall in proxy mode
*
*    DESCRIPTION
*      This java application mimics the employee application client accessing the protected database, using a shared application service account called EMPLOYEE_APPUSER
*      
*    NOTES
*      You will need to enter 4 arguments to execute the java program
*       Enter the Firewall IP address in args[0]
*       Enter the Proxy port number in args[1]
*       Enter the database service details in args[2]
*       Enter the password used for running hcm_data_script/hcm_workload_script in args[3]
*
*    MODIFIED   (MM/DD/YY)
*    adhanara    07/28/20 - Created
*
*/

import java.sql.*;  
class employee{  
	public static void main(String args[]){  
		try{  
		//step1 load the driver class  
			 Class.forName("oracle.jdbc.OracleDriver");
		   


			String connString= "jdbc:oracle:thin:@//"+args[0]+":"+args[1]+"/"+args[2];
System.out.println("Connection String entered is ::" + connString);
		String strUserID = "EMPLOYEE_APPUSER";
        //   String strUserID = "dba_harvey@example.com";
	       	String strPassword=args[3];
            
		 Connection conn=DriverManager.getConnection(connString,strUserID,strPassword);
			System.out.println("Training script for employee application SQL traffic");			  
			//step3 create the statement object  
			Statement stmt=conn.createStatement();  
			//step4 execute query  
          		ResultSet rs= stmt.executeQuery("select * from HCM.EMPLOYEES where employee_id=210");
			while(rs.next())  
			{
				System.out.println("Fetching the employee record :: "+rs.getString("FIRST_NAME"));  
			}	

		stmt.executeUpdate("update HCM.EMPLOYEES set FIRST_NAME='Sophie' where employee_id=210");  
		stmt.executeUpdate("update HCM.EMPLOYEES set LAST_NAME='Jain' where employee_id=210");  

		stmt.executeUpdate("update HCM.EMPLOYEES set PHONE_NUMBER='650.670.9800' where employee_id=210");
		stmt.executeUpdate("UPDATE HCM.SUPPLEMENTAL_DATA set LAST_INS_CLAIM=1000 where PERSON_ID =210");
		stmt.executeUpdate("UPDATE HCM.SUPPLEMENTAL_DATA set TAXPAYER_ID='123-45-6207' where PERSON_ID =210");
	  		rs=stmt.executeQuery("select * from HCM.SUPPLEMENTAL_DATA where PERSON_ID =210");

			while(rs.next())  
			{
				System.out.println("Completed updating the employee record :: "+rs.getString("USERNAME"));  
			}
rs=stmt.executeQuery("select * from HCM.EMPLOYEES where EMAIL IN ('sophie@example.com')");
			while(rs.next())  
			{
				System.out.println("Successful update processed for :: " +rs.getString("FIRST_NAME"));  
			}

//stmt.executeUpdate("update HCM.EMPLOYEES set SALARY=23999 where EMAIL IN ('sophie@example.com')");  
			
				System.out.println("Firewall training script successful");
			//step5 close the connection object  
			conn.close();  
		  
		}catch(Exception e){ System.out.println(e);}  
	  
	}  
} 