Rem hcm_data_script.sql
Rem
Rem Copyright  2020, Oracle and/or its affiliates. All rights reserved. This script is provided for educational purposes only and are not intended for production use, and the contents hereof are subject to change without notice. This script is not warranted to be error-free, nor subject to any other warranties or conditions, whether expressed orally or implied in law, including implied warranties and conditions of merchantability or fitness for a particular purpose. We specifically disclaim any liability with respect to this script, and no contractual obligations are formed either directly or indirectly by this script. 
Rem
Rem    NAME
Rem      hcm_data_script.sql - Data loading script for AVDF20 cookbook (Used for HR target)
Rem
Rem    DESCRIPTION
Rem      This scripts creates a schema user in your PDB instance named HCM, and creates and populates different tables within HCM schema, creates users, application context and audit policies.
Rem       
Rem
Rem    NOTES
Rem      To start using the script, you will need to run this script within the pdb instance
Rem      You will also need to enter the sys password as parameter when prompted
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    adhanara    07/28/20 - Created
Rem


/*************************************************************************************************/

--Enter the SYS password
def PW = &SYSPASSWORD

/*************************************************************************************************/
-- HCM schema user

def HCM_USER = HCM


/*************************************************************************************************/
--Creating users
connect sys/&PW as sysdba
--connect &ADMIN_USER/ADMIN_PW as sysdba

show user;

-- drop all accounts and recreate
-- These statements may error, that is acceptable.
--

DROP ROLE EMP_ROLE;
DROP ROLE HR_ROLE;
DROP ROLE HR_MGR;

drop user &HCM_USER cascade;

drop user "dba_debra@example.com" cascade;
drop user "dba_harvey@example.com" cascade;
drop user "dba_charles@example.com" cascade;

drop user "sophie@example.com" cascade;
drop user "lucas@example.com" cascade;
drop user "jron@example.com" cascade;
drop user "henrywil@example.com" cascade;
drop user "samkirk@example.com" cascade;


drop user "hr_tim@example.com" cascade;
drop user "hr_joe@example.com" cascade;
drop user "hr_jim@example.com" cascade;
drop user "hr_lan@example.com" cascade;
drop user "hr_ann@example.com" cascade;

drop user "secadmin_steve@example.com" cascade;

--application shared account --
drop user EMPLOYEE_APPUSER cascade;

--
-- create our sample users
-- these statements should not error. They should be successful on PDB.
-- DBA users in the system
create user &HCM_USER identified by &PW;
create user "dba_debra@example.com" identified by &PW;
create user "dba_harvey@example.com" identified by &PW;
create user "dba_charles@example.com" identified by &PW;

--Employees in the system
create user "sophie@example.com" identified by &PW;
create user "lucas@example.com" identified by &PW;
create user "jron@example.com" identified by &PW;
create user "henrywil@example.com" identified by &PW;
create user "samkirk@example.com" identified by &PW;

--Hr users in the system
create user "hr_tim@example.com" identified by &PW;
create user "hr_joe@example.com" identified by &PW;
create user "hr_jim@example.com" identified by &PW;
create user "hr_lan@example.com" identified by &PW;
create user "hr_ann@example.com" identified by &PW;
create user "secadmin_steve@example.com" identified by &PW;

-- grant our sample users connect, resource
grant connect, resource to "dba_debra@example.com";
grant connect, resource to &HCM_USER;
grant connect, resource to "dba_harvey@example.com";
grant connect, resource to "dba_charles@example.com";


grant connect, resource to "sophie@example.com";
grant connect, resource to "lucas@example.com";
grant connect, resource to "jron@example.com";
grant connect, resource to "henrywil@example.com";
grant connect, resource to "samkirk@example.com";
grant connect, resource to "hr_tim@example.com";
grant connect, resource to "hr_joe@example.com";
grant connect, resource to "hr_jim@example.com";
grant connect, resource to "hr_lan@example.com";
grant connect, resource to "hr_ann@example.com";

-- perform this grant separately 
grant DBA to "dba_harvey@example.com";
grant DBA to "dba_debra@example.com";
grant DBA to "dba_charles@example.com";
grant DBA to "secadmin_steve@example.com";

grant unlimited tablespace to "dba_harvey@example.com";
grant unlimited tablespace to "dba_debra@example.com";
grant unlimited tablespace to "dba_charles@example.com";

--Grant exemption to VPD policies to DBAs
grant exempt access policy to "dba_harvey@example.com";
grant exempt access policy to "dba_debra@example.com";
grant exempt access policy to "dba_charles@example.com";

grant unlimited tablespace to &HCM_USER;

--Security Administrator creation

grant unlimited tablespace to "secadmin_steve@example.com";
grant create session to "secadmin_steve@example.com" WITH ADMIN OPTION;
grant connect, resource to "secadmin_steve@example.com";
--connect sys/Welcome_1 as sysdba
grant select_catalog_role,select any table,create any context, drop any context, create user, alter user, drop user, create role, alter any role, 
drop any role,create table, create procedure, create any trigger, administer database trigger, create any directory, create profile, alter profile,
drop profile, audit system, alter system, grant any object privilege, grant any privilege, grant any role to "secadmin_steve@example.com";
connect sys/&PW as sysdba

grant CREATE ANY SYNONYM,CREATE ANY CONTEXT, DROP ANY CONTEXT,DROP ANY TRIGGER, CREATE PUBLIC SYNONYM to "secadmin_steve@example.com";

grant execute on DBMS_SESSION to "secadmin_steve@example.com";
grant execute on UTL_FILE to "secadmin_steve@example.com";

grant execute on dbms_rls to "secadmin_steve@example.com";

grant exempt access policy to "secadmin_steve@example.com";

grant execute on dbms_ldap to "secadmin_steve@example.com" with grant option;

--application shared account --

create user "EMPLOYEE_APPUSER" identified by &PW;
grant connect, resource to "EMPLOYEE_APPUSER";
--

/*************************************************************************************************/

/* BEGIN: Load_HCM_Data */

connect &HCM_USER/&PW
show user;

select null as "Load_HCM_Schema" from dual;
-- load our HCM objects and data


CREATE TABLE "EMPLOYEES" 
   (	"EMPLOYEE_ID" NUMBER(6,0), 
	"FIRST_NAME" VARCHAR2(20 BYTE), 
	"LAST_NAME" VARCHAR2(25 BYTE) CONSTRAINT "EMP_LAST_NAME_NN" NOT NULL ENABLE, 
	"EMAIL" VARCHAR2(25 BYTE) CONSTRAINT "EMP_EMAIL_NN" NOT NULL ENABLE, 
	"PHONE_NUMBER" VARCHAR2(20 BYTE), 
	"HIRE_DATE" DATE CONSTRAINT "EMP_HIRE_DATE_NN" NOT NULL ENABLE, 
	"JOB_ID" VARCHAR2(10 BYTE) CONSTRAINT "EMP_JOB_NN" NOT NULL ENABLE, 
	"SALARY" NUMBER(8,2), 
	"COMMISSION_PCT" NUMBER(2,2), 
	"MANAGER_ID" NUMBER(6,0), 
	"DEPARTMENT_ID" NUMBER(4,0), 
	 CONSTRAINT "EMP_SALARY_MIN" CHECK (salary > 0) ENABLE, 
	 CONSTRAINT "EMP_EMAIL_UK" UNIQUE ("EMAIL")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 NOLOGGING COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  ENABLE, 
	 CONSTRAINT "EMP_EMP_ID_PK" PRIMARY KEY ("EMPLOYEE_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 NOLOGGING COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  ENABLE ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS NOLOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT);
 
CREATE TABLE "DEPARTMENTS" 
   (	"DEPARTMENT_ID" NUMBER(4,0), 
	"DEPARTMENT_NAME" VARCHAR2(30 BYTE) CONSTRAINT "DEPT_NAME_NN" NOT NULL ENABLE, 
	"MANAGER_ID" NUMBER(6,0), 
	"LOCATION_ID" NUMBER(4,0), 
	 CONSTRAINT "DEPT_ID_PK" PRIMARY KEY ("DEPARTMENT_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 NOLOGGING COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  ENABLE 
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS NOLOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  ;

CREATE TABLE "COUNTRIES" 
   (	"COUNTRY_ID" CHAR(2 BYTE) CONSTRAINT "COUNTRY_ID_NN" NOT NULL ENABLE, 
	"COUNTRY_NAME" VARCHAR2(40 BYTE), 
	"REGION_ID" NUMBER, 
	 CONSTRAINT "COUNTRY_C_ID_PK" PRIMARY KEY ("COUNTRY_ID") ENABLE 
   ) ORGANIZATION INDEX NOCOMPRESS PCTFREE 10 INITRANS 2 MAXTRANS 255 NOLOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
 PCTTHRESHOLD 50;
 

CREATE TABLE "LOCATIONS" 
   (	"LOCATION_ID" NUMBER(4,0), 
	"STREET_ADDRESS" VARCHAR2(40 BYTE), 
	"POSTAL_CODE" VARCHAR2(12 BYTE), 
	"CITY" VARCHAR2(30 BYTE) CONSTRAINT "LOC_CITY_NN" NOT NULL ENABLE, 
	"STATE_PROVINCE" VARCHAR2(25 BYTE), 
	"COUNTRY_ID" CHAR(2 BYTE), 
	 CONSTRAINT "LOC_ID_PK" PRIMARY KEY ("LOCATION_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 NOLOGGING COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  ENABLE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS NOLOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
;
 

CREATE TABLE "REGIONS" 
   (	"REGION_ID" NUMBER CONSTRAINT "REGION_ID_NN" NOT NULL ENABLE, 
	"REGION_NAME" VARCHAR2(25 BYTE), 
	 CONSTRAINT "REG_ID_PK" PRIMARY KEY ("REGION_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 NOLOGGING COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
ENABLE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS NOLOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
;
 
  CREATE TABLE "JOB_HISTORY" 
   (	"EMPLOYEE_ID" NUMBER(6,0) CONSTRAINT "JHIST_EMPLOYEE_NN" NOT NULL ENABLE, 
	"DATE_OF_HIRE" DATE CONSTRAINT "JHIST_DATE_OF_HIRE_NN" NOT NULL ENABLE, 
	"DATE_OF_TERMINATION" DATE CONSTRAINT "JHIST_DATE_OF_TERMINATION_NN" NOT NULL ENABLE, 
	"JOB_ID" VARCHAR2(10 BYTE) CONSTRAINT "JHIST_JOB_NN" NOT NULL ENABLE, 
	"DEPARTMENT_ID" NUMBER(4,0), 
	 CONSTRAINT "JHIST_EMP_ID_ST_DATE_PK" PRIMARY KEY ("EMPLOYEE_ID", "DATE_OF_HIRE")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 NOLOGGING COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
ENABLE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS NOLOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
;
 

CREATE TABLE "JOBS"
   (    "JOB_ID" VARCHAR2(10),
        "JOB_TITLE" VARCHAR2(35) CONSTRAINT "JOB_TITLE_NN" NOT NULL ENABLE,
        "MIN_SALARY" NUMBER(6,0),
        "MAX_SALARY" NUMBER(6,0),
         CONSTRAINT "JOB_ID_PK" PRIMARY KEY ("JOB_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 NOLOGGING COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
ENABLE
   ) SEGMENT CREATION IMMEDIATE
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS NOLOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
;

CREATE INDEX "EMP_DEPARTMENT_IX" ON "EMPLOYEES" ("DEPARTMENT_ID");
 
CREATE INDEX "EMP_JOB_IX" ON "EMPLOYEES" ("JOB_ID");
 
CREATE INDEX "EMP_MANAGER_IX" ON "EMPLOYEES" ("MANAGER_ID");
 
CREATE INDEX "EMP_NAME_IX" ON "EMPLOYEES" ("LAST_NAME", "FIRST_NAME");

CREATE INDEX "DEPT_LOCATION_IX" ON "DEPARTMENTS" ("LOCATION_ID");
 
CREATE INDEX "LOC_CITY_IX" ON "LOCATIONS" ("CITY");
  
CREATE INDEX "LOC_STATE_PROVINCE_IX" ON "LOCATIONS" ("STATE_PROVINCE");
  
CREATE INDEX "LOC_COUNTRY_IX" ON "LOCATIONS" ("COUNTRY_ID");
  
CREATE INDEX "JHIST_JOB_IX" ON "JOB_HISTORY" ("JOB_ID");
  
CREATE INDEX "JHIST_EMPLOYEE_IX" ON "JOB_HISTORY" ("EMPLOYEE_ID");
  
CREATE INDEX "JHIST_DEPARTMENT_IX" ON "JOB_HISTORY" ("DEPARTMENT_ID");
   
CREATE TABLE CONDITIONS(CONDITION_ID NUMBER, CONDITION VARCHAR2(2000));

CREATE OR REPLACE FUNCTION RETURN_CONDITION RETURN VARCHAR2 IS
V_CONDITION VARCHAR2(2000);
V_CONDITION_ID NUMBER := TRUNC(DBMS_RANDOM.VALUE(1,10));
BEGIN
  SELECT CONDITION INTO V_CONDITION FROM CONDITIONS WHERE CONDITION_ID=V_CONDITION_ID;
  DBMS_OUTPUT.PUT_LINE('CONDITION_ID IS:'||V_CONDITION_ID);
  RETURN V_CONDITION;
END;
/

CREATE SEQUENCE EMPID START WITH 300;

CREATE TABLE SUPPLEMENTAL_DATA (PERSON_ID NUMBER, USERNAME VARCHAR2(50), 
TAXPAYER_ID VARCHAR2(20), LAST_INS_CLAIM VARCHAR2(2000), BONUS_AMOUNT NUMBER);

--conditions
insert into conditions values (1,'Broken Arm');
insert into conditions values (2,'Hair Loss');
insert into conditions values (3,'Halitosis');
insert into conditions values (4,'Social Disease');
insert into conditions values (5,'Cavity');
insert into conditions values (6,'Myopia');
insert into conditions values (7,'Hangnail');
insert into conditions values (8,'Common Cold');
insert into conditions values (9,'Embarrassing Skin Condition');

--employees supplemental
insert into supplemental_data values(100,'SKING','','','');
insert into supplemental_data values(101,'NKOCHHAR','','','');
insert into supplemental_data values(102,'LDEHAAN','','','');
insert into supplemental_data values(103,'AHUNOLD','','','');
insert into supplemental_data values(104,'BERNST','','','');
insert into supplemental_data values(105,'DAUSTIN','','','');
insert into supplemental_data values(106,'VPATABAL','','','');
insert into supplemental_data values(107,'DLORENTZ','','','');
insert into supplemental_data values(108,'NGREENBE','','','');
insert into supplemental_data values(109,'DFAVIET','','','');
insert into supplemental_data values(110,'JCHEN','','','');
insert into supplemental_data values(111,'ISCIARRA','','','');
insert into supplemental_data values(112,'JMURMAN','','','');
insert into supplemental_data values(113,'LPOPP','','','');
insert into supplemental_data values(114,'DRAPHEAL','','','');
insert into supplemental_data values(115,'AKHOO','','','');
insert into supplemental_data values(116,'SBAIDA','','','');
insert into supplemental_data values(117,'STOBIAS','','','');
insert into supplemental_data values(118,'GHIMURO','','','');
insert into supplemental_data values(119,'KCOLMENA','','','');
insert into supplemental_data values(120,'MWEISS','','','');
insert into supplemental_data values(121,'AFRIPP','','','');
insert into supplemental_data values(122,'PKAUFLIN','','','');
insert into supplemental_data values(123,'SVOLLMAN','','','');
insert into supplemental_data values(124,'KMOURGOS','','','');
insert into supplemental_data values(125,'JNAYER','','','');
insert into supplemental_data values(126,'IMIKKILI','','','');
insert into supplemental_data values(127,'JLANDRY','','','');
insert into supplemental_data values(128,'SMARKLE','','','');
insert into supplemental_data values(129,'LBISSOT','','','');
insert into supplemental_data values(130,'MATKINSO','','','');
insert into supplemental_data values(131,'JAMRLOW','','','');
insert into supplemental_data values(132,'TJOLSON','','','');
insert into supplemental_data values(133,'JMALLIN','','','');
insert into supplemental_data values(134,'MROGERS','','','');
insert into supplemental_data values(135,'KGEE','','','');
insert into supplemental_data values(136,'HPHILTAN','','','');
insert into supplemental_data values(137,'RLADWIG','','','');
insert into supplemental_data values(138,'SSTILES','','','');
insert into supplemental_data values(139,'JSEO','','','');
insert into supplemental_data values(140,'JPATEL','','','');
insert into supplemental_data values(141,'TRAJS','','','');
insert into supplemental_data values(142,'CDAVIES','','','');
insert into supplemental_data values(143,'RMATOS','','','');
insert into supplemental_data values(144,'PVARGAS','','','');
insert into supplemental_data values(145,'JRUSSEL','','','');
insert into supplemental_data values(146,'KPARTNER','','','');
insert into supplemental_data values(147,'AERRAZUR','','','');
insert into supplemental_data values(148,'GCAMBRAU','','','');
insert into supplemental_data values(149,'EZLOTKEY','','','');
insert into supplemental_data values(150,'PTUCKER','','','');
insert into supplemental_data values(151,'DBERNSTE','','','');
insert into supplemental_data values(152,'PHALL','','','');
insert into supplemental_data values(153,'COLSEN','','','');
insert into supplemental_data values(154,'NCAMBRAU','','','');
insert into supplemental_data values(155,'OTUVAULT','','','');
insert into supplemental_data values(156,'JKING','','','');
insert into supplemental_data values(157,'PSULLY','','','');
insert into supplemental_data values(158,'AMCEWEN','','','');
insert into supplemental_data values(159,'LSMITH','','','');
insert into supplemental_data values(160,'LDORAN','','','');
insert into supplemental_data values(161,'SSEWALL','','','');
insert into supplemental_data values(162,'CVISHNEY','','','');
insert into supplemental_data values(163,'DGREENE','','','');
insert into supplemental_data values(164,'MMARVINS','','','');
insert into supplemental_data values(165,'DLEE','','','');
insert into supplemental_data values(166,'SANDE','','','');
insert into supplemental_data values(167,'ABANDA','','','');
insert into supplemental_data values(168,'LOZER','','','');
insert into supplemental_data values(169,'HBLOOM','','','');
insert into supplemental_data values(170,'TFOX','','','');
insert into supplemental_data values(171,'WSMITH','','','');
insert into supplemental_data values(172,'EBATES','','','');
insert into supplemental_data values(173,'SKUMAR','','','');
insert into supplemental_data values(174,'EABEL','','','');
insert into supplemental_data values(175,'AHUTTON','','','');
insert into supplemental_data values(176,'JTAYLOR','','','');
insert into supplemental_data values(177,'JLIVINGS','','','');
insert into supplemental_data values(178,'KGRANT','','','');
insert into supplemental_data values(179,'CJOHNSON','','','');
insert into supplemental_data values(180,'WTAYLOR','','','');
insert into supplemental_data values(181,'JFLEAUR','','','');
insert into supplemental_data values(182,'MSULLIVA','','','');
insert into supplemental_data values(183,'GGEONI','','','');
insert into supplemental_data values(184,'NSARCHAN','','','');
insert into supplemental_data values(185,'ABULL','','','');
insert into supplemental_data values(186,'JDELLING','','','');
insert into supplemental_data values(187,'ACABRIO','','','');
insert into supplemental_data values(188,'KCHUNG','','','');
insert into supplemental_data values(189,'JDILLY','','','');
insert into supplemental_data values(190,'TGATES','','','');
insert into supplemental_data values(191,'RPERKINS','','','');
insert into supplemental_data values(192,'SBELL','','','');
insert into supplemental_data values(193,'BEVERETT','','','');
insert into supplemental_data values(194,'SMCCAIN','','','');
insert into supplemental_data values(195,'VJONES','','','');
insert into supplemental_data values(196,'AWALSH','','','');
insert into supplemental_data values(197,'KFEENEY','','','');
insert into supplemental_data values(198,'DOCONNEL','','','');
insert into supplemental_data values(199,'DGRANT','','','');
insert into supplemental_data values(200,'JWHALEN','','','');
insert into supplemental_data values(201,'MHARTSTE','','','');
insert into supplemental_data values(202,'PFAY','','','');
insert into supplemental_data values(203,'SMAVRIS','','','');
insert into supplemental_data values(204,'HBAER','','','');
insert into supplemental_data values(205,'SHIGGINS','','','');
insert into supplemental_data values(206,'WGIETZ','','','');
insert into supplemental_data values(210,'SJAIN','','','');
--msad supplemental
insert into supplemental_data values(empid.nextval,'auser','','','');
insert into supplemental_data values(empid.nextval,'buser','','','');
insert into supplemental_data values(empid.nextval,'cuser','','','');
insert into supplemental_data values(empid.nextval,'duser','','','');
insert into supplemental_data values(empid.nextval,'euser','','','');
insert into supplemental_data values(empid.nextval,'fuser','','','');
insert into supplemental_data values(empid.nextval,'guser','','','');
insert into supplemental_data values(empid.nextval,'huser','','','');
insert into supplemental_data values(empid.nextval,'iuser','','','');
insert into supplemental_data values(empid.nextval,'juser','','','');
insert into supplemental_data values(empid.nextval,'kuser','','','');
insert into supplemental_data values(empid.nextval,'luser','','','');
insert into supplemental_data values(empid.nextval,'muser','','','');
insert into supplemental_data values(empid.nextval,'nuser','','','');
insert into supplemental_data values(empid.nextval,'ouser','','','');
insert into supplemental_data values(empid.nextval,'puser','','','');
insert into supplemental_data values(empid.nextval,'quser','','','');
insert into supplemental_data values(empid.nextval,'ruser','','','');
insert into supplemental_data values(empid.nextval,'suser','','','');
insert into supplemental_data values(empid.nextval,'tuser','','','');
insert into supplemental_data values(empid.nextval,'uuser','','','');
insert into supplemental_data values(empid.nextval,'vuser','','','');
insert into supplemental_data values(empid.nextval,'wuser','','','');
insert into supplemental_data values(empid.nextval,'xuser','','','');
insert into supplemental_data values(empid.nextval,'yuser','','','');
insert into supplemental_data values(empid.nextval,'zuser','','','');
--oud/oid supplemental
insert into supplemental_data values(empid.nextval,'aworker','','','');
insert into supplemental_data values(empid.nextval,'bworker','','','');
insert into supplemental_data values(empid.nextval,'cworker','','','');
insert into supplemental_data values(empid.nextval,'dworker','','','');
insert into supplemental_data values(empid.nextval,'eworker','','','');
insert into supplemental_data values(empid.nextval,'fworker','','','');
insert into supplemental_data values(empid.nextval,'gworker','','','');
insert into supplemental_data values(empid.nextval,'hworker','','','');
insert into supplemental_data values(empid.nextval,'amanager','','','');
insert into supplemental_data values(empid.nextval,'bmanager','','','');
insert into supplemental_data values(empid.nextval,'cmanager','','','');
insert into supplemental_data values(empid.nextval,'dmanager','','','');
insert into supplemental_data values(empid.nextval,'adirector','','','');
insert into supplemental_data values(empid.nextval,'bdirector','','','');
insert into supplemental_data values(empid.nextval,'aadmin','','','');
insert into supplemental_data values(empid.nextval,'badmin','','','');
commit;
update supplemental_data set taxpayer_id='987-65-4320';
update supplemental_data set bonus_amount=trunc(dbms_random.value(1000,99999));
commit;
update supplemental_data set LAST_INS_CLAIM= return_condition;
update supplemental_data set LAST_INS_CLAIM='Unverified Complaint' where LAST_INS_CLAIM is null;
commit;
drop table conditions;
drop function return_condition;
alter table supplemental_data add (payment_acct_no varchar2(20));
update supplemental_data set payment_acct_no=to_char(trunc(dbms_random.value(1,4)))||to_char(trunc(dbms_random.value(100,999)))||'-'||to_char(trunc(dbms_random.value(1000,9900)))||'-'||to_char(trunc(dbms_random.value(1000,9900)))||'-'||to_char(trunc(dbms_random.value(1000,9900)));
commit;
--REM INSERTING into COUNTRIES
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('AR','Argentina',2);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('AU','Australia',3);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('BE','Belgium',1);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('BR','Brazil',2);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('CA','Canada',2);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('CH','Switzerland',1);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('CN','China',3);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('DE','Germany',1);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('DK','Denmark',1);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('EG','Egypt',4);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('FR','France',1);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('IL','Israel',4);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('IN','India',3);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('IT','Italy',1);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('JP','Japan',3);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('KW','Kuwait',4);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('ML','Malaysia',3);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('MX','Mexico',2);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('NG','Nigeria',4);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('NL','Netherlands',1);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('SG','Singapore',3);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('UK','United Kingdom',1);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('US','United States of America',2);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('ZM','Zambia',4);
Insert into countries (COUNTRY_ID,COUNTRY_NAME,REGION_ID) values ('ZW','Zimbabwe',4);
--REM INSERTING into departments
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (10,'Administration',200,1000);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (20,'Marketing',201,1800);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (30,'Purchasing',114,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (40,'Human Resources',203,1100);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (50,'Shipping',121,1200);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (60,'IT',103,1400);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (70,'Public Relations',204,2700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (80,'Sales',145,1300);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (90,'Executive',100,1000);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (100,'Finance',108,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (110,'Accounting',205,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (120,'Treasury',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (130,'Corporate Tax',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (140,'Control And Credit',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (150,'Shareholder Services',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (160,'Benefits',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (170,'Manufacturing',null,1100);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (180,'Construction',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (190,'Contracting',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (200,'Operations',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (210,'IT Support',null,1000);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (220,'NOC',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (230,'IT Helpdesk',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (240,'Government Sales',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (250,'Retail Sales',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (260,'Recruiting',null,1700);
Insert into departments (DEPARTMENT_ID,DEPARTMENT_NAME,MANAGER_ID,LOCATION_ID) values (270,'Payroll',null,1000);
--REM INSERTING into employees
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (198,'Donald','OConnell','DOCONNEL@example.com','650.555.0100',to_timestamp('21-JUN-07','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',2600,null,124,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (199,'Douglas','Grant','DGRANT@example.com','650.555.0101',to_timestamp('13-JAN-08','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',2600,null,124,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (200,'Jennifer','Whalen','JWHALEN@example.com','925.555.0102',to_timestamp('17-SEP-03','DD-MON-RR HH.MI.SSXFF AM'),'AD_ASST',4400,null,101,10);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (201,'Michael','Hartstein','MHARTSTE@example.com','415.555.0103',to_timestamp('17-FEB-04','DD-MON-RR HH.MI.SSXFF AM'),'MK_MAN',13000,null,100,20);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (202,'Pat','Fay','PFAY@example.com','415.555.0104',to_timestamp('17-AUG-05','DD-MON-RR HH.MI.SSXFF AM'),'MK_REP',6000,null,201,20);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (203,'Susan','Mavris','SMAVRIS@example.com','925.555.0105',to_timestamp('07-JUN-02','DD-MON-RR HH.MI.SSXFF AM'),'HR_REP',6500,null,101,40);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (204,'Hermann','Baer','HBAER@example.com','415.555.0106',to_timestamp('07-JUN-02','DD-MON-RR HH.MI.SSXFF AM'),'PR_REP',10000,null,101,70);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (205,'Shelley','Higgins','SHIGGINS@example.com','415.555.0107',to_timestamp('07-JUN-02','DD-MON-RR HH.MI.SSXFF AM'),'AC_MGR',12008,null,101,110);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (206,'William','Gietz','WGIETZ@example.com','415.555.0108',to_timestamp('07-JUN-02','DD-MON-RR HH.MI.SSXFF AM'),'AC_ACCOUNT',8300,null,205,110);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (100,'Steven','King','SKING@example.com','415.555.0109',to_timestamp('17-JUN-03','DD-MON-RR HH.MI.SSXFF AM'),'AD_PRES',24000,null,null,90);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (101,'Neena','Kochhar','NKOCHHAR@example.com','415.555.0110',to_timestamp('21-SEP-05','DD-MON-RR HH.MI.SSXFF AM'),'AD_VP',17000,null,100,90);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (102,'Lex','De Haan','LDEHAAN@example.com','415.555.0111',to_timestamp('13-JAN-01','DD-MON-RR HH.MI.SSXFF AM'),'AD_VP',17000,null,100,90);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (103,'Alexander','Hunold','AHUNOLD@example.com','415.555.0112',to_timestamp('03-JAN-06','DD-MON-RR HH.MI.SSXFF AM'),'IT_PROG',9000,null,102,60);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (104,'Bruce','Ernst','BERNST@example.com','415.555.0113',to_timestamp('21-MAY-07','DD-MON-RR HH.MI.SSXFF AM'),'IT_PROG',6000,null,103,60);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (105,'David','Austin','DAUSTIN@example.com','415.555.0114',to_timestamp('25-JUN-05','DD-MON-RR HH.MI.SSXFF AM'),'IT_PROG',4800,null,103,60);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (106,'Valli','Pataballa','VPATABAL@example.com','415.555.0115',to_timestamp('05-FEB-06','DD-MON-RR HH.MI.SSXFF AM'),'IT_PROG',4800,null,103,60);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (107,'Diana','Lorentz','DLORENTZ@example.com','415.555.0116',to_timestamp('07-FEB-07','DD-MON-RR HH.MI.SSXFF AM'),'IT_PROG',4200,null,103,60);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (108,'Nancy','Greenberg','NGREENBE@example.com','650.555.0117',to_timestamp('17-AUG-02','DD-MON-RR HH.MI.SSXFF AM'),'FI_MGR',12008,null,101,100);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (109,'Daniel','Faviet','DFAVIET@example.com','650.555.0118',to_timestamp('16-AUG-02','DD-MON-RR HH.MI.SSXFF AM'),'FI_ACCOUNT',9000,null,108,100);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (110,'John','Chen','JCHEN@example.com','650.555.0119',to_timestamp('28-SEP-05','DD-MON-RR HH.MI.SSXFF AM'),'FI_ACCOUNT',8200,null,108,100);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (111,'Ismael','Sciarra','ISCIARRA@example.com','650.555.0120',to_timestamp('30-SEP-05','DD-MON-RR HH.MI.SSXFF AM'),'FI_ACCOUNT',7700,null,108,100);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (112,'Jose Manuel','Urman','JMURMAN@example.com','650.555.0121',to_timestamp('07-MAR-06','DD-MON-RR HH.MI.SSXFF AM'),'FI_ACCOUNT',7800,null,108,100);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (113,'Luis','Popp','LPOPP@example.com','650.555.0122',to_timestamp('07-DEC-07','DD-MON-RR HH.MI.SSXFF AM'),'FI_ACCOUNT',6900,null,108,100);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (114,'Den','Raphaely','DRAPHEAL@example.com','415.555.0123',to_timestamp('07-DEC-02','DD-MON-RR HH.MI.SSXFF AM'),'PU_MAN',11000,null,100,30);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (115,'Alexander','Khoo','AKHOO@example.com','415.555.0124',to_timestamp('18-MAY-03','DD-MON-RR HH.MI.SSXFF AM'),'PU_CLERK',3100,null,114,30);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (116,'Shelli','Baida','SBAIDA@example.com','415.555.0125',to_timestamp('24-DEC-05','DD-MON-RR HH.MI.SSXFF AM'),'PU_CLERK',2900,null,114,30);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (117,'Sigal','Tobias','STOBIAS@example.com','415.555.0126',to_timestamp('24-JUL-05','DD-MON-RR HH.MI.SSXFF AM'),'PU_CLERK',2800,null,114,30);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (118,'Guy','Himuro','GHIMURO@example.com','415.555.0127',to_timestamp('15-NOV-06','DD-MON-RR HH.MI.SSXFF AM'),'PU_CLERK',2600,null,114,30);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (119,'Karen','Colmenares','KCOLMENA@example.com','415.555.0128',to_timestamp('10-AUG-07','DD-MON-RR HH.MI.SSXFF AM'),'PU_CLERK',2500,null,114,30);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (120,'Matthew','Weiss','MWEISS@example.com','650.555.0129',to_timestamp('18-JUL-04','DD-MON-RR HH.MI.SSXFF AM'),'ST_MAN',8000,null,100,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (121,'Adam','Fripp','AFRIPP@example.com','650.555.0130',to_timestamp('10-APR-05','DD-MON-RR HH.MI.SSXFF AM'),'ST_MAN',8200,null,100,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (122,'Payam','Kaufling','PKAUFLIN@example.com','650.555.0131',to_timestamp('01-MAY-03','DD-MON-RR HH.MI.SSXFF AM'),'ST_MAN',7900,null,100,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (123,'Shanta','Vollman','SVOLLMAN@example.com','650.555.0132',to_timestamp('10-OCT-05','DD-MON-RR HH.MI.SSXFF AM'),'ST_MAN',6500,null,100,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (124,'Kevin','Mourgos','KMOURGOS@example.com','650.555.0133',to_timestamp('16-NOV-07','DD-MON-RR HH.MI.SSXFF AM'),'ST_MAN',5800,null,100,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (125,'Julia','Nayer','JNAYER@example.com','650.555.0134',to_timestamp('16-JUL-05','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',3200,null,120,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (126,'Irene','Mikkilineni','IMIKKILI@example.com','650.555.0135',to_timestamp('28-SEP-06','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2700,null,120,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (127,'James','Landry','JLANDRY@example.com','650.555.0136',to_timestamp('14-JAN-07','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2400,null,120,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (128,'Steven','Markle','SMARKLE@example.com','650.555.0137',to_timestamp('08-MAR-08','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2200,null,120,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (129,'Laura','Bissot','LBISSOT@example.com','650.555.0138',to_timestamp('20-AUG-05','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',3300,null,121,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (130,'Mozhe','Atkinson','MATKINSO@example.com','650.555.0139',to_timestamp('30-OCT-05','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2800,null,121,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (131,'James','Marlow','JAMRLOW@example.com','650.555.0140',to_timestamp('16-FEB-05','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2500,null,121,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (132,'TJ','Olson','TJOLSON@example.com','650.555.0141',to_timestamp('10-APR-07','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2100,null,121,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (133,'Jason','Mallin','JMALLIN@example.com','650.555.0142',to_timestamp('14-JUN-04','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',3300,null,122,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (134,'Michael','Rogers','MROGERS@example.com','650.555.0143',to_timestamp('26-AUG-06','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2900,null,122,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (135,'Ki','Gee','KGEE@example.com','650.555.0144',to_timestamp('12-DEC-07','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2400,null,122,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (136,'Hazel','Philtanker','HPHILTAN@example.com','650.555.0145',to_timestamp('06-FEB-08','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2200,null,122,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (137,'Renske','Ladwig','RLADWIG@example.com','650.555.0146',to_timestamp('14-JUL-03','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',3600,null,123,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (138,'Stephen','Stiles','SSTILES@example.com','650.555.0147',to_timestamp('26-OCT-05','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',3200,null,123,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (139,'John','Seo','JSEO@example.com','650.555.0148',to_timestamp('12-FEB-06','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2700,null,123,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (140,'Joshua','Patel','JPATEL@example.com','650.555.0149',to_timestamp('06-APR-06','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2500,null,123,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (141,'Trenna','Rajs','TRAJS@example.com','650.555.0150',to_timestamp('17-OCT-03','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',3500,null,124,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (142,'Curtis','Davies','CDAVIES@example.com','650.555.0151',to_timestamp('29-JAN-05','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',3100,null,124,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (143,'Randall','Matos','RMATOS@example.com','650.555.0152',to_timestamp('15-MAR-06','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2600,null,124,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (144,'Peter','Vargas','PVARGAS@example.com','650.555.0153',to_timestamp('09-JUL-06','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',2500,null,124,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (145,'John','Russell','JRUSSEL@example.com','415.555.0154',to_timestamp('01-OCT-04','DD-MON-RR HH.MI.SSXFF AM'),'SA_MAN',14000,0.4,100,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (146,'Karen','Partners','KPARTNER@example.com','415.555.0155',to_timestamp('05-JAN-05','DD-MON-RR HH.MI.SSXFF AM'),'SA_MAN',13500,0.3,100,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (147,'Alberto','Errazuriz','AERRAZUR@example.com','415.555.0156',to_timestamp('10-MAR-05','DD-MON-RR HH.MI.SSXFF AM'),'SA_MAN',12000,0.3,100,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (148,'Gerald','Cambrault','GCAMBRAU@example.com','415.555.0157',to_timestamp('15-OCT-07','DD-MON-RR HH.MI.SSXFF AM'),'SA_MAN',11000,0.3,100,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (149,'Eleni','Zlotkey','EZLOTKEY@example.com','415.555.0158',to_timestamp('29-JAN-08','DD-MON-RR HH.MI.SSXFF AM'),'SA_MAN',10500,0.2,100,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (150,'Peter','Tucker','PTUCKER@example.com','415.555.0159',to_timestamp('30-JAN-05','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',10000,0.3,145,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (151,'David','Bernstein','DBERNSTE@example.com','415.555.0160',to_timestamp('24-MAR-05','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',9500,0.25,145,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (152,'Peter','Hall','PHALL@example.com','415.555.0161',to_timestamp('20-AUG-05','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',9000,0.25,145,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (153,'Christopher','Olsen','COLSEN@example.com','415.555.0162',to_timestamp('30-MAR-06','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',8000,0.2,145,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (154,'Nanette','Cambrault','NCAMBRAU@example.com','415.555.0163',to_timestamp('09-DEC-06','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',7500,0.2,145,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (155,'Oliver','Tuvault','OTUVAULT@example.com','415.555.0164',to_timestamp('23-NOV-07','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',7000,0.15,145,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (156,'Janette','King','JKING@example.com','415.555.0165',to_timestamp('30-JAN-04','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',10000,0.35,146,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (157,'Patrick','Sully','PSULLY@example.com','415.555.0166',to_timestamp('04-MAR-04','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',9500,0.35,146,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (158,'Allan','McEwen','AMCEWEN@example.com','415.555.0167',to_timestamp('01-AUG-04','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',9000,0.35,146,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (159,'Lindsey','Smith','LSMITH@example.com','415.555.0168',to_timestamp('10-MAR-05','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',8000,0.3,146,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (160,'Louise','Doran','LDORAN@example.com','415.555.0169',to_timestamp('15-DEC-05','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',7500,0.3,146,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (161,'Sarath','Sewall','SSEWALL@example.com','415.555.0170',to_timestamp('03-NOV-06','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',7000,0.25,146,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (162,'Clara','Vishney','CVISHNEY@example.com','415.555.0171',to_timestamp('11-NOV-05','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',10500,0.25,147,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (163,'Danielle','Greene','DGREENE@example.com','415.555.0172',to_timestamp('19-MAR-07','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',9500,0.15,147,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (164,'Mattea','Marvins','MMARVINS@example.com','415.555.0173',to_timestamp('24-JAN-08','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',7200,0.1,147,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (165,'David','Lee','DLEE@example.com','415.555.0174',to_timestamp('23-FEB-08','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',6800,0.1,147,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (166,'Sundar','Ande','SANDE@example.com','415.555.0175',to_timestamp('24-MAR-08','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',6400,0.1,147,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (167,'Amit','Banda','ABANDA@example.com','415.555.0176',to_timestamp('21-APR-08','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',6200,0.1,147,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (168,'Lisa','Ozer','LOZER@example.com','415.555.0177',to_timestamp('11-MAR-05','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',11500,0.25,148,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (169,'Harrison','Bloom','HBLOOM@example.com','415.555.0178',to_timestamp('23-MAR-06','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',10000,0.2,148,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (170,'Tayler','Fox','TFOX@example.com','415.555.0179',to_timestamp('24-JAN-06','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',9600,0.2,148,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (171,'William','Smith','WSMITH@example.com','415.555.0180',to_timestamp('23-FEB-07','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',7400,0.15,148,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (172,'Elizabeth','Bates','EBATES@example.com','415.555.0181',to_timestamp('24-MAR-07','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',7300,0.15,148,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (173,'Sundita','Kumar','SKUMAR@example.com','415.555.0182',to_timestamp('21-APR-08','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',6100,0.1,148,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (174,'Ellen','Abel','EABEL@example.com','415.555.0183',to_timestamp('11-MAY-04','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',11000,0.3,149,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (175,'Alyssa','Hutton','AHUTTON@example.com','415.555.0184',to_timestamp('19-MAR-05','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',8800,0.25,149,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (176,'Jonathon','Taylor','JTAYLOR@example.com','415.555.0185',to_timestamp('24-MAR-06','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',8600,0.2,149,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (177,'Jack','Livingston','JLIVINGS@example.com','415.555.0186',to_timestamp('23-APR-06','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',8400,0.2,149,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (178,'Kimberely','Grant','KGRANT@example.com','415.555.0187',to_timestamp('24-MAY-07','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',7000,0.15,149,null);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (179,'Charles','Johnson','CJOHNSON@example.com','415.555.0188',to_timestamp('04-JAN-08','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',6200,0.1,149,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (180,'Winston','Taylor','WTAYLOR@example.com','650.555.0189',to_timestamp('24-JAN-06','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',3200,null,120,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (181,'Jean','Fleaur','JFLEAUR@example.com','650.555.0190',to_timestamp('23-FEB-06','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',3100,null,120,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (182,'Martha','Sullivan','MSULLIVA@example.com','650.555.0191',to_timestamp('21-JUN-07','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',2500,null,120,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (183,'Girard','Geoni','GGEONI@example.com','650.555.0192',to_timestamp('03-FEB-08','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',2800,null,120,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (184,'Nandita','Sarchand','NSARCHAN@example.com','650.555.0193',to_timestamp('27-JAN-04','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',4200,null,121,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (185,'Alexis','Bull','ABULL@example.com','650.555.0194',to_timestamp('20-FEB-05','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',4100,null,121,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (186,'Julia','Dellinger','JDELLING@example.com','650.555.0195',to_timestamp('24-JUN-06','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',3400,null,121,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (187,'Anthony','Cabrio','ACABRIO@example.com','650.555.0196',to_timestamp('07-FEB-07','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',3000,null,121,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (188,'Kelly','Chung','KCHUNG@example.com','650.555.0197',to_timestamp('14-JUN-05','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',3800,null,122,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (189,'Jennifer','Dilly','JDILLY@example.com','650.555.0198',to_timestamp('13-AUG-05','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',3600,null,122,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (190,'Timothy','Gates','TGATES@example.com','650.555.0199',to_timestamp('11-JUL-06','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',2900,null,122,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (191,'Randall','Perkins','RPERKINS@example.com','650.555.0161',to_timestamp('19-DEC-07','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',2500,null,122,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (192,'Sarah','Bell','SBELL@example.com','650.555.0162',to_timestamp('04-FEB-04','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',4000,null,123,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (193,'Britney','Everett','BEVERETT@example.com','650.555.0163',to_timestamp('03-MAR-05','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',3900,null,123,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (194,'Samuel','McCain','SMCCAIN@example.com','650.555.0164',to_timestamp('01-JUL-06','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',3200,null,123,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (195,'Vance','Jones','VJONES@example.com','650.555.0165',to_timestamp('17-MAR-07','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',2800,null,123,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (196,'Alana','Walsh','AWALSH@example.com','650.555.0166',to_timestamp('24-APR-06','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',3100,null,124,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (197,'Kevin','Feeney','KFEENEY@example.com','650.555.0167',to_timestamp('23-MAY-06','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',3000,null,124,50);

--For our sample Employee accounts--
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (210,'Sophie','Jain','sophie@example.com','925.555.0168',to_timestamp('10-JUN-06','DD-MON-RR HH.MI.SSXFF AM'),'EMPLOYEE',3000,null,124,10);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (211,'Lucas','Wales','lucas@example.com','925.555.0169',to_timestamp('23-MAY-07','DD-MON-RR HH.MI.SSXFF AM'),'EMPLOYEE',3000,null,124,10);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (212,'James','Ronwar','jron@example.com','925.555.0170',to_timestamp('23-DEC-05','DD-MON-RR HH.MI.SSXFF AM'),'EMPLOYEE',3000,null,124,10);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (213,'Henry','Williams','henrywil@example.com','925.555.0171',to_timestamp('13-APR-09','DD-MON-RR HH.MI.SSXFF AM'),'EMPLOYEE',3000,null,124,10);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (214,'Samuel','Kirk','samkirk@example.com','925.555.0172',to_timestamp('23-JUL-04','DD-MON-RR HH.MI.SSXFF AM'),'EMPLOYEE',3000,null,124,10);

--For our sample HR User accounts--


Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (250,'Tim','Conor','hr_tim@example.com','925.555.0173',to_timestamp('10-JUN-06','DD-MON-RR HH.MI.SSXFF AM'),'HR_REP',5000,null,124,10);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (251,'Joe','Wales','hr_joe@example.com','650.555.0174',to_timestamp('23-MAY-07','DD-MON-RR HH.MI.SSXFF AM'),'HR_REP',6000,null,124,50);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (252,'Jim','Wan','hr_jim@example.com','650.555.0175',to_timestamp('23-DEC-05','DD-MON-RR HH.MI.SSXFF AM'),'HR_REP',8000,null,124,80);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (253,'Lan','Sherlomes','hr_lan@example.com','650.555.0176',to_timestamp('13-APR-09','DD-MON-RR HH.MI.SSXFF AM'),'HR_REP',3000,null,124,100);
Insert into employees (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (255,'Ann','Mccain','hrmgr_annmc@example.com','650.555.0177',to_timestamp('23-JUL-04','DD-MON-RR HH.MI.SSXFF AM'),'HR_MGR',10000,null,124,80);

--REM INSERTING into jobs
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('AD_PRES','President',20080,40000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('AD_VP','Administration Vice President',15000,30000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('AD_ASST','Administration Assistant',3000,6000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('FI_MGR','Finance Manager',8200,16000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('FI_ACCOUNT','Accountant',4200,9000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('AC_MGR','Accounting Manager',8200,16000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('AC_ACCOUNT','Public Accountant',4200,9000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('SA_MAN','Sales Manager',10000,20080);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('SA_REP','Sales Representative',6000,12008);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('PU_MAN','Purchasing Manager',8000,15000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('PU_CLERK','Purchasing Clerk',2500,5500);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('ST_MAN','Stock Manager',5500,8500);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('ST_CLERK','Stock Clerk',2008,5000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('SH_CLERK','Shipping Clerk',2500,5500);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('IT_PROG','Programmer',4000,10000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('MK_MAN','Marketing Manager',9000,15000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('MK_REP','Marketing Representative',4000,9000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('HR_REP','Human Resources Representative',4000,9000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('PR_REP','Public Relations Representative',4500,10500);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('EMPLOYEE','Employee',6000,8000);
Insert into jobs (JOB_ID,JOB_TITLE,MIN_SALARY,MAX_SALARY) values ('HR_MGR','Human Resources Manager',7000,9000);

--REM INSERTING into job_history
Insert into job_history (EMPLOYEE_ID,DATE_OF_HIRE,DATE_OF_TERMINATION,JOB_ID,DEPARTMENT_ID) values (102,to_timestamp('13-JAN-01','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('24-JUL-06','DD-MON-RR HH.MI.SSXFF AM'),'IT_PROG',60);
Insert into job_history (EMPLOYEE_ID,DATE_OF_HIRE,DATE_OF_TERMINATION,JOB_ID,DEPARTMENT_ID) values (101,to_timestamp('21-SEP-97','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('27-OCT-01','DD-MON-RR HH.MI.SSXFF AM'),'AC_ACCOUNT',110);
Insert into job_history (EMPLOYEE_ID,DATE_OF_HIRE,DATE_OF_TERMINATION,JOB_ID,DEPARTMENT_ID) values (101,to_timestamp('28-OCT-01','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-MAR-05','DD-MON-RR HH.MI.SSXFF AM'),'AC_MGR',110);
Insert into job_history (EMPLOYEE_ID,DATE_OF_HIRE,DATE_OF_TERMINATION,JOB_ID,DEPARTMENT_ID) values (201,to_timestamp('17-FEB-04','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('19-DEC-07','DD-MON-RR HH.MI.SSXFF AM'),'MK_REP',20);
Insert into job_history (EMPLOYEE_ID,DATE_OF_HIRE,DATE_OF_TERMINATION,JOB_ID,DEPARTMENT_ID) values (114,to_timestamp('24-MAR-06','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('31-DEC-07','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',50);
Insert into job_history (EMPLOYEE_ID,DATE_OF_HIRE,DATE_OF_TERMINATION,JOB_ID,DEPARTMENT_ID) values (122,to_timestamp('01-JAN-07','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('31-DEC-07','DD-MON-RR HH.MI.SSXFF AM'),'ST_CLERK',50);
Insert into job_history (EMPLOYEE_ID,DATE_OF_HIRE,DATE_OF_TERMINATION,JOB_ID,DEPARTMENT_ID) values (200,to_timestamp('17-SEP-95','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-JUN-01','DD-MON-RR HH.MI.SSXFF AM'),'AD_ASST',90);
Insert into job_history (EMPLOYEE_ID,DATE_OF_HIRE,DATE_OF_TERMINATION,JOB_ID,DEPARTMENT_ID) values (176,to_timestamp('24-MAR-06','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('31-DEC-06','DD-MON-RR HH.MI.SSXFF AM'),'SA_REP',80);
Insert into job_history (EMPLOYEE_ID,DATE_OF_HIRE,DATE_OF_TERMINATION,JOB_ID,DEPARTMENT_ID) values (176,to_timestamp('01-JAN-07','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('31-DEC-07','DD-MON-RR HH.MI.SSXFF AM'),'SA_MAN',80);
Insert into job_history (EMPLOYEE_ID,DATE_OF_HIRE,DATE_OF_TERMINATION,JOB_ID,DEPARTMENT_ID) values (200,to_timestamp('01-JUL-02','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('31-DEC-06','DD-MON-RR HH.MI.SSXFF AM'),'AC_ACCOUNT',90);
--REM INSERTING into locations
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (1000,'5805 Owens Drive','94588','Pleasanton','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (1100,'5815 Owens Drive','	94588','Pleasanton','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (1200,'100 Oracle Parkway','94065','Redwood City','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (1300,'200 Oracle Parkway','94065','Redwood City','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (1400,'300 Oracle Parkway','94065','Redwood City','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (1500,'400 Oracle Parkway','94065','Redwood City','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (1600,'500 Oracle Parkway','94065','Redwood City','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (1700,'600 Oracle Parkway','94065','Redwood City','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (1800,'401 Island Parkway','94002','Belmont','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (1900,'501 Island Parkway','94002','Belmont','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (2000,'4090 Network Circle','95054','Santa Clara','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (2100,'4100 Network Circle','95054','Santa Clara','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (2200,'4110 Network Circle','95054','Santa Clara','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (2300,'4120 Network Circle','95054','Santa Clara','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (2400,'4140 Network Circle','95054','Santa Clara','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (2500,'4150 Network Circle','95054','Santa Clara','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (2600,'4180 Network Circle','95054','Santa Clara','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (2700,'4190 Network Circle','95054','Santa Clara','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (2800,'4220 Network Circle','95054','Santa Clara','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (2900,'4040 Palm Drive','95054','Santa Clara','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (3000,'4060 George Sellon Circle','95054','Santa Clara','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (3100,'4070 George Sellon Circle','95054','Santa Clara','California (CA)','US');
Insert into locations (LOCATION_ID,STREET_ADDRESS,POSTAL_CODE,CITY,STATE_PROVINCE,COUNTRY_ID) values (3200,'4230 Leonard Stocking Drive','95054','Santa Clara','California (CA)','US');
--REM INSERTING into REGIONS
Insert into regions (REGION_ID,REGION_NAME) values (1,'Europe');
Insert into regions (REGION_ID,REGION_NAME) values (2,'Americas');
Insert into regions (REGION_ID,REGION_NAME) values (3,'Asia');
Insert into regions (REGION_ID,REGION_NAME) values (4,'Middle East and Africa');
--REM Applying constraints
alter table employees add CONSTRAINT "EMP_MANAGER_FK" FOREIGN KEY ("MANAGER_ID")REFERENCES EMPLOYEES ("EMPLOYEE_ID") ENABLE; 
alter table employees add CONSTRAINT "EMP_JOB_FK" FOREIGN KEY ("JOB_ID")REFERENCES JOBS ("JOB_ID") ENABLE;
alter table employees add  CONSTRAINT "EMP_DEPT_FK" FOREIGN KEY ("DEPARTMENT_ID")REFERENCES DEPARTMENTS ("DEPARTMENT_ID") ENABLE;
alter table departments add CONSTRAINT "DEPT_MGR_FK" FOREIGN KEY ("MANAGER_ID")REFERENCES EMPLOYEES ("EMPLOYEE_ID") ENABLE;
alter table departments add CONSTRAINT "DEPT_LOC_FK" FOREIGN KEY ("LOCATION_ID")REFERENCES LOCATIONS ("LOCATION_ID") ENABLE;
alter table countries add CONSTRAINT "COUNTR_REG_FK" FOREIGN KEY ("REGION_ID")REFERENCES REGIONS ("REGION_ID") ENABLE;
alter table locations add CONSTRAINT "LOC_C_ID_FK" FOREIGN KEY ("COUNTRY_ID")REFERENCES COUNTRIES ("COUNTRY_ID") ENABLE;
alter table job_history add CONSTRAINT "JHIST_DEPT_FK" FOREIGN KEY ("DEPARTMENT_ID")REFERENCES DEPARTMENTS ("DEPARTMENT_ID") ENABLE;
alter table job_history add CONSTRAINT "JHIST_EMP_FK" FOREIGN KEY ("EMPLOYEE_ID")REFERENCES EMPLOYEES ("EMPLOYEE_ID") ENABLE;
alter table job_history add CONSTRAINT "JHIST_JOB_FK" FOREIGN KEY ("JOB_ID")REFERENCES JOBS ("JOB_ID") ENABLE;
--REM employees extended table
CREATE TABLE EMP_EXTENDED AS SELECT EMPLOYEE_ID FROM EMPLOYEES;
ALTER TABLE EMP_EXTENDED ADD CONSTRAINT EMP_EXTENDED_EMPID_FK FOREIGN KEY (EMPLOYEE_ID) REFERENCES EMPLOYEES(EMPLOYEE_ID);

ALTER TABLE EMP_EXTENDED ADD (TAXPAYERID VARCHAR2(15), PAYMENTACCOUNTNO VARCHAR2(20));

update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326100' where employee_id=100;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326101' where employee_id=101;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326102' where employee_id=102;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326103' where employee_id=103;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326104' where employee_id=104;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326105' where employee_id=105;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326106' where employee_id=106;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326107' where employee_id=107;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326108' where employee_id=108;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326109' where employee_id=109;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326110' where employee_id=110;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326111' where employee_id=111;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326112' where employee_id=112;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326113' where employee_id=113;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326114' where employee_id=114;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326115' where employee_id=115;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326116' where employee_id=116;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326117' where employee_id=117;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326118' where employee_id=118;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326119' where employee_id=119;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326120' where employee_id=120;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326121' where employee_id=121;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326122' where employee_id=122;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326123' where employee_id=123;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326124' where employee_id=124;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326125' where employee_id=125;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326126' where employee_id=126;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326127' where employee_id=127;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326128' where employee_id=128;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326129' where employee_id=129;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326130' where employee_id=130;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326131' where employee_id=131;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326132' where employee_id=132;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326133' where employee_id=133;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326134' where employee_id=134;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326135' where employee_id=135;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326136' where employee_id=136;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326137' where employee_id=137;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326138' where employee_id=138;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326139' where employee_id=139;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326140' where employee_id=140;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326141' where employee_id=141;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326142' where employee_id=142;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326143' where employee_id=143;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326144' where employee_id=144;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326145' where employee_id=145;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326146' where employee_id=146;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326147' where employee_id=147;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326148' where employee_id=148;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326149' where employee_id=149;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326150' where employee_id=150;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326151' where employee_id=151;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326152' where employee_id=152;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326153' where employee_id=153;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326154' where employee_id=154;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326155' where employee_id=155;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326156' where employee_id=156;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326157' where employee_id=157;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326158' where employee_id=158;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326159' where employee_id=159;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326160' where employee_id=160;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326161' where employee_id=161;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326162' where employee_id=162;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326163' where employee_id=163;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326164' where employee_id=164;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326165' where employee_id=165;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326166' where employee_id=166;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326167' where employee_id=167;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326168' where employee_id=168;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326169' where employee_id=169;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326170' where employee_id=170;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326171' where employee_id=171;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326172' where employee_id=172;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326173' where employee_id=173;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326174' where employee_id=174;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326175' where employee_id=175;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326176' where employee_id=176;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326177' where employee_id=177;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326178' where employee_id=178;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326179' where employee_id=179;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326180' where employee_id=180;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326181' where employee_id=181;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326182' where employee_id=182;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326183' where employee_id=183;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326184' where employee_id=184;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326185' where employee_id=185;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326186' where employee_id=186;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326187' where employee_id=187;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326188' where employee_id=188;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326189' where employee_id=189;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326190' where employee_id=190;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326191' where employee_id=191;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326192' where employee_id=192;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326193' where employee_id=193;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326194' where employee_id=194;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326195' where employee_id=195;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326196' where employee_id=196;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326197' where employee_id=197;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326198' where employee_id=198;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326199' where employee_id=199;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326200' where employee_id=200;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326201' where employee_id=201;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326202' where employee_id=202;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326203' where employee_id=203;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326204' where employee_id=204;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326205' where employee_id=205;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326206' where employee_id=206;

--for sample accounts
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326207' where employee_id=210;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326208' where employee_id=211;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326209' where employee_id=212;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326210' where employee_id=213;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326211' where employee_id=214;
update emp_extended set taxpayerID='987-65-4320', paymentAccountNo='4321123454326212' where employee_id=255;
commit;
--
--Add column comments
comment on column employees.employee_id is 'This is the unqiue employee identifier.';
comment on column employees.email is 'This is the email address.';
comment on column employees.salary is 'This is the employees salary - treat as sensitive.';
comment on column job_history.date_of_hire is 'This is the hire date.';
comment on column job_history.date_of_termination is 'This is the termination date.';
comment on column supplemental_data.last_ins_claim is 'Insurance claim must have the healthcare provider details.';


/* END: Load_HCM_Data */

/*************************************************************************************************/

-- verify it loaded successfully 
select count(*) as EMPLOYEES from EMPLOYEES;
select count(*) as DEPARTMENTS from DEPARTMENTS;
select count(*) as COUNTRIES from COUNTRIES;
select count(*) as LOCATIONS from LOCATIONS;
select count(*) as REGIONS from REGIONS;
select count(*) as JOB_HISTORY from JOB_HISTORY;
select count(*) as JOBS from JOBS;

--Creating and granting roles /privileges to users:

connect sys/&PW as sysdba

CREATE ROLE EMP_ROLE;
CREATE ROLE HR_ROLE;
CREATE ROLE HR_MGR;

--Emp Role--
GRANT SELECT on HCM.EMPLOYEES TO EMP_ROLE;
GRANT UPDATE (first_name,last_name,phone_number) ON HCM.EMPLOYEES TO EMP_ROLE;
GRANT SELECT on HCM.SUPPLEMENTAL_DATA TO EMP_ROLE;
GRANT UPDATE  (TAXPAYER_ID,LAST_INS_CLAIM,BONUS_AMOUNT) on HCM.SUPPLEMENTAL_DATA TO EMP_ROLE;
GRANT SELECT on HCM.EMP_EXTENDED TO EMP_ROLE;
GRANT UPDATE  (TAXPAYERID,PAYMENTACCOUNTNO) on HCM.EMP_EXTENDED TO EMP_ROLE;
GRANT SELECT on HCM.JOBS to EMP_ROLE;
GRANT SELECT on HCM.DEPARTMENTS to EMP_ROLE;
--HR Role--

GRANT ALL ON HCM.EMPLOYEES TO HR_ROLE;
GRANT ALL ON HCM.SUPPLEMENTAL_DATA TO HR_ROLE;
GRANT ALL ON HCM.EMP_EXTENDED TO HR_ROLE;
GRANT ALL ON HCM.JOB_HISTORY TO HR_ROLE;
GRANT SELECT on HCM.DEPARTMENTS TO HR_ROLE;
GRANT SELECT on HCM.COUNTRIES TO HR_ROLE;
GRANT SELECT on HCM.LOCATIONS TO HR_ROLE;
GRANT SELECT on HCM.REGIONS TO HR_ROLE;
GRANT SELECT on HCM.JOBS TO HR_ROLE;

--HR_MGR role--
GRANT HR_ROLE TO HR_MGR;
GRANT ALL ON HCM.DEPARTMENTS TO HR_MGR;
GRANT ALL ON HCM.COUNTRIES TO HR_MGR;
GRANT ALL ON HCM.LOCATIONS TO HR_MGR;
GRANT ALL ON HCM.REGIONS TO HR_MGR;
GRANT ALL ON HCM.JOBS TO HR_MGR;

--Granting to Employees--
grant EMP_ROLE to "sophie@example.com";
grant EMP_ROLE to "lucas@example.com";
grant EMP_ROLE to "jron@example.com";
grant EMP_ROLE to "henrywil@example.com";
grant EMP_ROLE to "samkirk@example.com";

grant EMP_ROLE to "EMPLOYEE_APPUSER";
--Granting to HR Users--

grant HR_ROLE to "hr_tim@example.com";
grant HR_ROLE to "hr_joe@example.com";
grant HR_ROLE to "hr_jim@example.com";
grant HR_ROLE to "hr_lan@example.com";
--HR Ann is HR manager--
grant HR_MGR to "hr_ann@example.com";

--END: Creating and granting roles /privileges to users:


/*************************************************************************************************/

/* BEGIN: Set relevant application context for execution */


connect "secadmin_steve@example.com"/&PW
drop context APPUSER_CONTEXT;
--drop public synonym set_demo_pkg;

create context APPUSER_CONTEXT using set_appuser_pkg;
CREATE OR REPLACE PACKAGE set_appuser_pkg
IS
 
 PROCEDURE set_context_values(p_value in varchar2);
 
END set_appuser_pkg;
/

CREATE OR REPLACE PACKAGE BODY set_appuser_pkg
AS
 PROCEDURE set_context_values(p_value in varchar2)
 IS
  
   BEGIN
    
   	DBMS_SESSION.SET_CONTEXT('APPUSER_CONTEXT', 'APP_USER', p_value);
	DBMS_SESSION.SET_CONTEXT('APPUSER_CONTEXT', 'CLIENT_INFO', SYS_CONTEXT('USERENV','SESSION_USER'));
    --DBMS_SESSION.SET_IDENTIFIER(p_value);
END set_context_values;

END set_appuser_pkg;

/

grant execute on set_appuser_pkg to PUBLIC;

create or replace public synonym set_appuser_pkg for set_appuser_pkg;

connect sys/&PW as sysdba
show user;
AUDIT CONTEXT NAMESPACE APPUSER_CONTEXT ATTRIBUTES APP_USER,CLIENT_INFO;

/* END: SetupEnv */

/*************************************************************************************************/


/* BEGIN: SetupAuditPolicies */
connect sys/&PW as sysdba

NOAUDIT POLICY USER_ACTIVITY_NOT_IN_APP_PATH by users with granted roles EMP_ROLE,HR_ROLE,HR_MGR;
DROP AUDIT POLICY USER_ACTIVITY_NOT_IN_APP_PATH;

NOAUDIT POLICY UNAUTHORIZED_ACTIVITY_BY_EMP by users with granted roles EMP_ROLE;
DROP AUDIT POLICY UNAUTHORIZED_ACTIVITY_BY_EMP;

NOAUDIT POLICY UNAUTHORIZED_ACTIVITY_BY_HR by users with granted roles HR_ROLE;
DROP AUDIT POLICY UNAUTHORIZED_ACTIVITY_BY_HR;

NOAUDIT POLICY UNAUTHORIZED_ACTIVITY_BY_HRMGR by users with granted roles HR_MGR;
DROP AUDIT POLICY UNAUTHORIZED_ACTIVITY_BY_HRMGR;

--These policies are enabled in the UI as part of provisioning audit policies from AVDF UI.Hence disabling /dropping them to be re-runnable.
--NOAUDIT POLICY ORA_ACCOUNT_MGMT;
--NOAUDIT POLICY ORA_DATABASE_PARAMETER;
NOAUDIT POLICY ORA_LOGON_FAILURES;
NOAUDIT POLICY ORA_SECURECONFIG;

NOAUDIT POLICY ORA_AV$_CRITICAL_DB_ACTIVITY;
DROP AUDIT POLICY ORA_AV$_CRITICAL_DB_ACTIVITY;

NOAUDIT POLICY ORA_AV$_DB_SCHEMA_CHANGES;
DROP AUDIT POLICY ORA_AV$_DB_SCHEMA_CHANGES;

NOAUDIT POLICY ORA_AV$_ADMIN_USER_ACTIVITY BY USERS WITH GRANTED ROLES DBA,
DATAPUMP_EXP_FULL_DATABASE, DATAPUMP_IMP_FULL_DATABASE, EXP_FULL_DATABASE, 
IMP_FULL_DATABASE;
NOAUDIT POLICY ORA_AV$_ADMIN_USER_ACTIVITY BY PUBLIC, SYSDG, SYSKM, SYSRAC, SYSBACKUP;
DROP AUDIT POLICY ORA_AV$_ADMIN_USER_ACTIVITY;

NOAUDIT POLICY ORA_AV$_SYS_TOP_ACTIVITY by SYS;
DROP AUDIT POLICY ORA_AV$_SYS_TOP_ACTIVITY;
-- Creating custom audit policies

--Create unified audit policy to track selects, updates, deletes and inserts on all HCM tables if it is not from trusted application paths.

CREATE AUDIT POLICY USER_ACTIVITY_NOT_IN_APP_PATH
  ACTIONS ALL ON &HCM_USER..EMPLOYEES
        , ALL ON &HCM_USER..EMP_EXTENDED
        , ALL ON &HCM_USER..SUPPLEMENTAL_DATA
        , ALL ON &HCM_USER..JOB_HISTORY
        , ALL ON &HCM_USER..DEPARTMENTS
        , ALL ON &HCM_USER..COUNTRIES
        , ALL ON &HCM_USER..LOCATIONS
        , ALL ON &HCM_USER..REGIONS
        , ALL ON &HCM_USER..JOBS
        --WHEN 'SYS_CONTEXT(''APPUSER_CONTEXT'', ''APP_USER'') IN (''EMPLOYEE_USER'',''HR_USER'',''HR_MANAGER'')' 
          WHEN 'SYS_CONTEXT(''APPUSER_CONTEXT'', ''APP_USER'') NOT IN (''EMPLOYEE_USER'',''HR_USER'',''HR_MANAGER'')' 
          EVALUATE PER STATEMENT
          ONLY TOPLEVEL;
AUDIT POLICY USER_ACTIVITY_NOT_IN_APP_PATH by users with granted roles EMP_ROLE,HR_ROLE,HR_MGR;

       
--To audit unauthorized activities that can take place in trusted path itself ( eg : Employee given more than necessary privileges such that he has access to updates JOBS from the UI itself).

CREATE AUDIT POLICY UNAUTHORIZED_ACTIVITY_BY_EMP
  ACTIONS 
          INSERT ON &HCM_USER..EMPLOYEES, DELETE ON &HCM_USER..EMPLOYEES 
        , INSERT ON &HCM_USER..EMP_EXTENDED, DELETE ON &HCM_USER..EMP_EXTENDED 
        , INSERT ON &HCM_USER..SUPPLEMENTAL_DATA, DELETE ON &HCM_USER..SUPPLEMENTAL_DATA
        , INSERT ON &HCM_USER..JOB_HISTORY, UPDATE ON &HCM_USER..JOB_HISTORY, DELETE ON &HCM_USER..JOB_HISTORY
        , INSERT ON &HCM_USER..DEPARTMENTS, UPDATE ON &HCM_USER..DEPARTMENTS, DELETE ON &HCM_USER..DEPARTMENTS
        , INSERT ON &HCM_USER..COUNTRIES, UPDATE ON &HCM_USER..COUNTRIES, DELETE ON &HCM_USER..COUNTRIES
        , INSERT ON &HCM_USER..LOCATIONS, UPDATE ON &HCM_USER..LOCATIONS, DELETE ON &HCM_USER..LOCATIONS
        , INSERT ON &HCM_USER..REGIONS, UPDATE ON &HCM_USER..REGIONS, DELETE ON &HCM_USER..REGIONS
        , INSERT ON &HCM_USER..JOBS, UPDATE ON &HCM_USER..JOBS, DELETE ON &HCM_USER..JOBS
--          WHEN 'SYS_CONTEXT(''APPUSER_CONTEXT'', ''APP_USER'') IN (''EMPLOYEE_USER'')' 
--          EVALUATE PER STATEMENT
          ONLY TOPLEVEL;
AUDIT POLICY UNAUTHORIZED_ACTIVITY_BY_EMP by users with granted roles EMP_ROLE;


CREATE AUDIT POLICY UNAUTHORIZED_ACTIVITY_BY_HR
  ACTIONS 
          INSERT ON &HCM_USER..DEPARTMENTS, UPDATE ON &HCM_USER..DEPARTMENTS, DELETE ON &HCM_USER..DEPARTMENTS
        , INSERT ON &HCM_USER..COUNTRIES, UPDATE ON &HCM_USER..COUNTRIES, DELETE ON &HCM_USER..COUNTRIES
        , INSERT ON &HCM_USER..LOCATIONS, UPDATE ON &HCM_USER..LOCATIONS, DELETE ON &HCM_USER..LOCATIONS
        , INSERT ON &HCM_USER..REGIONS, UPDATE ON &HCM_USER..REGIONS, DELETE ON &HCM_USER..REGIONS
        , INSERT ON &HCM_USER..JOBS, UPDATE ON &HCM_USER..JOBS, DELETE ON &HCM_USER..JOBS
          WHEN 'SYS_CONTEXT(''APPUSER_CONTEXT'', ''APP_USER'') IN (''HR_USER'')' 
          EVALUATE PER STATEMENT
          ONLY TOPLEVEL;
AUDIT POLICY UNAUTHORIZED_ACTIVITY_BY_HR by users with granted roles HR_ROLE;


CREATE AUDIT POLICY UNAUTHORIZED_ACTIVITY_BY_HRMGR
  ACTIONS 
          TRUNCATE TABLE
        , CREATE TABLE, ALTER TABLE, DROP TABLE
        , CREATE AUDIT POLICY,  ALTER AUDIT POLICY, DROP AUDIT POLICY
        , COMMENT ON &HCM_USER..EMPLOYEES, INDEX ON &HCM_USER..EMPLOYEES
        , COMMENT ON &HCM_USER..EMP_EXTENDED, INDEX ON &HCM_USER..EMP_EXTENDED
        , COMMENT ON &HCM_USER..SUPPLEMENTAL_DATA, INDEX ON &HCM_USER..SUPPLEMENTAL_DATA
        , COMMENT ON &HCM_USER..JOB_HISTORY, INDEX ON &HCM_USER..JOB_HISTORY
        , COMMENT ON &HCM_USER..DEPARTMENTS, INDEX ON &HCM_USER..DEPARTMENTS
        , COMMENT ON &HCM_USER..COUNTRIES, INDEX ON &HCM_USER..COUNTRIES
        , COMMENT ON &HCM_USER..LOCATIONS,  INDEX ON &HCM_USER..LOCATIONS
        , COMMENT ON &HCM_USER..REGIONS, INDEX ON &HCM_USER..REGIONS
        , COMMENT ON &HCM_USER..JOBS, INDEX ON &HCM_USER..JOBS
          WHEN 'SYS_CONTEXT(''APPUSER_CONTEXT'', ''APP_USER'') IN (''HR_MANAGER'')' 
          EVALUATE PER STATEMENT
          ONLY TOPLEVEL;
AUDIT POLICY UNAUTHORIZED_ACTIVITY_BY_HRMGR by users with granted roles HR_MGR;


/* END: SetupAuditPolicies */

-- Create a user for dbsat to configure:---------------
-- This might be required incase you are running DBSAT , not otherwise.
connect sys/&PW as sysdba
--connect &ADMIN_USER/ADMIN_PW as sysdba

show user;

drop user dbsat_user;
create user dbsat_user identified by Welcome_1;

GRANT CREATE SESSION TO dbsat_user;
GRANT SELECT on SYS.REGISTRY$HISTORY TO dbsat_user;
GRANT SELECT_CATALOG_ROLE TO dbsat_user;
GRANT AUDIT_VIEWER TO dbsat_user;
GRANT CAPTURE_ADMIN TO dbsat_user;
GRANT SELECT on SYS.DBA_USERS_WITH_DEFPWD TO dbsat_user;
GRANT SELECT on AUDSYS.AUD$UNIFIED TO dbsat_user;

