Rem hcm_workload_script.sql
Rem
Rem Copyright  2020, Oracle and/or its affiliates. All rights reserved. This script is provided for educational purposes only and are not intended for production use, and the contents hereof are subject to change without notice. This script is not warranted to be error-free, nor subject to any other warranties or conditions, whether expressed orally or implied in law, including implied warranties and conditions of merchantability or fitness for a particular purpose. We specifically disclaim any liability with respect to this script, and no contractual obligations are formed either directly or indirectly by this script. 
Rem
Rem    NAME
Rem      hcm_workload_script.sql - Workload script for AVDF20 cookbook (Used for HR target)
Rem
Rem    DESCRIPTION
Rem      This scripts run different workloads as different users - DBA users, Employees, HR users and managers.
Rem       Trusted path of Employee application users are set with application context. Anything outside the trusted application path are audited by policies, audit event generated for scrutinizing it further from AVDF
Rem
Rem    NOTES
Rem      To start using the script, run this script in the pdb instance where you configured HCM schema user
Rem      You will also need to enter the sys password as parameter when prompted
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    adhanara    07/28/20 - Created
Rem


/*************************************************************************************************/

/* Workload to generate audit events */
--Enter the SYS password
def PW = &SYSPASSWORD


def HCM_USER = HCM

def EMP_ID = 181
def LOC_ID = 2900
def DEPT_ID = 80

/*************************************************************************************************/
/* BEGIN: DBA Workload */
/* BEGIN: DBA_Queries1 */

select null as "DBA_Queries1" from dual;

connect "dba_debra@example.com"/&PW
show user;

--
-- Gather table statistics as an example of an action a DBA might take. 
--
exec dbms_stats.gather_table_stats('&HCM_USER','EMPLOYEES');

/* END: DBA_Queries1 */

/*************************************************************************************************/

/* BEGIN: DBA_Queries2 */

select null as "DBA_Queries2 :EXPECTED TO ERROR" from dual;


connect "dba_charles@example.com"/&PW
show user;

--
-- Switch logfile is an example of an action a DBA might take. 

alter system switch logfile;  

/* END: DBA_Queries2 */

/*************************************************************************************************/

/* BEGIN: DBA_Queries3 */

select null as "DBA_Queries3" from dual;

--
-- Basic queries as an example of an action a DBA might take. 
--
connect "dba_harvey@example.com"/&PW
show user;

select count(*) From v$session;
select * from gv$instance;
select count(*) from v$process;
select sessions_max, sessions_current, sessions_highwater, users_max from v$license;

select b.paddr , b.name nme, b.description descr, to_char(b.error) cerror from  v$bgprocess b, v$process p where  b.paddr = p.addr;

select sequence#, group#, first_change#, first_time, archived, bytes from v$log order by sequence#, group#;

select count(*)
from sys.dba_segments a
where a.tablespace_name not like 'T%MP%'
   and nvl(a.next_extent,a.initial_extent) * 1 > 
    (select max(b.bytes) from dba_free_space b where a.tablespace_name = b.tablespace_name);


SELECT count(*)
FROM (SELECT tablespace_name, SUM (blocks) ublocks
        FROM dba_segments
        GROUP BY tablespace_name) s,
     (SELECT tablespace_name, SUM (blocks) fblocks
        FROM dba_free_space
        GROUP BY tablespace_name) f,
     (SELECT tablespace_name, SUM(blocks) ablocks
        FROM dba_data_files
        GROUP BY tablespace_name) a
WHERE s.tablespace_name = f.tablespace_name and
      s.tablespace_name = a.tablespace_name and
      s.tablespace_name not in ('SYSTEM','SYSAUX','TOOLS','UNDO01') and
      ((s.ublocks/a.ablocks)*100) > 50;

--
-- Some of the queries as DBA_DEBRA might fail. 
-- This is acceptable behavior.
--
connect "dba_debra@example.com"/&PW
show user;

select count(*)
from    v$sysstat a, v$statname b
where   a.statistic# = b.statistic#;

select sum(getmisses)/sum(gets)*100 dict_cache from v$rowcache;

select sum(reloads)/sum(pins) *100 lib_cache from v$librarycache;

connect "dba_harvey@example.com"/&PW
show user;

select  count(*)
from   v$sysstat
where  name in ('sorts (memory)', 'sorts (disk)','sorts (rows)');

select   count(*)
from	v$sysstat
where   name = 'free buffer waits';

SELECT  count(*)
FROM	v$system_event SE,
	(SELECT SUM(time_waited) total_waittime FROM v$system_event
	WHERE wait_class NOT IN ('Idle','Network'))
WHERE	total_waits > 0
	AND time_waited > 1000
	AND wait_class NOT IN ('Idle','Network');


/* END: DBA_Queries3 */

/*************************************************************************************************/

/* BEGIN: DBA_Queries4 */

select null as "DBA_Queries4" from dual;

-- 
-- Rebuilding indexes is an example of action a DBA might take
-- Does it generate audit data? Are the failures important?
-- 
connect "dba_charles@example.com"/&PW
show user;

begin 
for x in (select owner, index_name from dba_indexes where owner = '&HCM_USER') loop

begin
dbms_output.put_line('rebuilding '||x.owner||'.'||x.index_name||'...');
execute immediate 'alter index '||x.owner||'.'||x.index_name||' rebuild';
exception when others then
 null;
end;

end loop;
end;
/
--Charles DBA granting excessive privileges to Employee Sophie

grant select on &HCM_USER..JOB_HISTORY to "sophie@example.com";
grant select on &HCM_USER..LOCATIONS to "sophie@example.com";

--Charles DBA granting excessive privileges to Employee Lucas
grant insert on &HCM_USER..EMPLOYEES to "lucas@example.com";
/* END: DBA_Queries4 */


/*************************************************************************************************/
/* BEGIN: Employee_Queries5 from Employees*/

select null as "Employee_Queries5" from dual;

--Basic queries an employees would typically take--
connect "sophie@example.com"/&PW

show user;
BEGIN
 set_appuser_pkg.set_context_values('EMPLOYEE_USER');
END;
/
-- Normal queries of Employee: Sophie--
select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID from &HCM_USER..EMPLOYEES;
update &HCM_USER..EMPLOYEES set PHONE_NUMBER='650.670.9800';
select * from &HCM_USER..emp_extended where employee_id =&EMP_ID;
select LAST_INS_CLAIM from &HCM_USER..SUPPLEMENTAL_DATA where PERSON_ID =&EMP_ID;
UPDATE &HCM_USER..SUPPLEMENTAL_DATA set LAST_INS_CLAIM=1000 where PERSON_ID =&EMP_ID;

--Malicious attempts by Sophie--
select * from &HCM_USER..JOB_HISTORY; -- attempt to see job history of all employees from UI which she will be successful.
--Now she attempts to set their payment account information to Sophie's account number via backend to siphon off funds.

connect "sophie@example.com"/&PW
SET SERVEROUTPUT ON;
BEGIN
 set_appuser_pkg.set_context_values('UNKNOWN');
END;
/
select * from &HCM_USER..JOB_HISTORY;
select PAYMENTACCOUNTNO from &HCM_USER..emp_extended where employee_id=101;
select PAYMENTACCOUNTNO from &HCM_USER..emp_extended where employee_id=102;
select PAYMENTACCOUNTNO from &HCM_USER..emp_extended where employee_id=103;
select PAYMENTACCOUNTNO from &HCM_USER..emp_extended where employee_id=104;
select PAYMENTACCOUNTNO from &HCM_USER..emp_extended where employee_id=105;

update  &HCM_USER..emp_extended set PAYMENTACCOUNTNO='4321123454326207' where employee_id=101;
update  &HCM_USER..emp_extended set PAYMENTACCOUNTNO='4321123454326207' where employee_id=102;
update  &HCM_USER..emp_extended set PAYMENTACCOUNTNO='4321123454326207' where employee_id=103;
update  &HCM_USER..emp_extended set PAYMENTACCOUNTNO='4321123454326207' where employee_id=104;
update  &HCM_USER..emp_extended set PAYMENTACCOUNTNO='4321123454326207' where employee_id=105;

--END: Malicious attempts by Sophie--

connect "lucas@example.com"/&PW

show user;
BEGIN
 set_appuser_pkg.set_context_values('EMPLOYEE_USER');
END;
/
-- Normal queries of Lucas--

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID from &HCM_USER..EMPLOYEES;
update &HCM_USER..EMPLOYEES set PHONE_NUMBER='650.670.9700';
select * from &HCM_USER..emp_extended where employee_id =&EMP_ID;
select LAST_INS_CLAIM from &HCM_USER..SUPPLEMENTAL_DATA where PERSON_ID =&EMP_ID;
UPDATE &HCM_USER..SUPPLEMENTAL_DATA set LAST_INS_CLAIM='2000' where PERSON_ID =&EMP_ID;

--Lucas tries to insert a new EMPLOYEE record - she is not authorized but somehow has been granted INSERT privileges ( more privileges than authorized) by DBA Charles  
Insert into &HCM_USER..EMPLOYEES (EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID) values (301,'Donald','Mark','markdonald@example.com','650.507.9833',to_timestamp('21-JUN-07','DD-MON-RR HH.MI.SSXFF AM'),'SH_CLERK',2600,null,124,50);
rollback;
--Malicious attempts by Lucas from backend to see data of other employees--
BEGIN
 set_appuser_pkg.set_context_values('UNKNOWN');
END;
/
--UPDATE &HCM_USER..EMPLOYEES set COMMISSION_PCT = 37;
select LAST_INS_CLAIM from &HCM_USER..SUPPLEMENTAL_DATA order by 1;
select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID from &HCM_USER..EMPLOYEES order by last_name;
select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID from &HCM_USER..EMPLOYEES order by last_name;
select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, SALARY,COMMISSION_PCT,MANAGER_ID from &HCM_USER..EMPLOYEES where department_id = &DEPT_ID order by manager_id;
select * from &HCM_USER..emp_extended where employee_id = &EMP_ID;
--select * from &HCM_USER..LOCATIONS where location_id = &LOC_ID;
select LAST_NAME, FIRST_NAME, EMAIL from &HCM_USER..employees where manager_id = &EMP_ID order by 2;

--END: Malicious attempts by Lucas--
/* END: Employee_Queries5 */

/*************************************************************************************************/

/* BEGIN: DBA_Work6 */

select null as "DBA_Work6" from dual;

--
-- Basic queries as an example of an action a DBA or end-user might take. 
-- ALTER SYSTEM commands might fail in a PDB or ADB.  This is acceptable. 
--
connect "dba_debra@example.com"/&PW
show user; 

show parameter processes
alter system set processes = 505 scope=memory;--EXPECTED TO ERROR

select * from v$parameter where name like '%optimizer_index%';
alter system set optimizer_index_cost_adj = 85 scope=memory;

--
-- Basic actions a DBA or end-user might take. 
--
alter table &HCM_USER..employees modify phone_number varchar2(20); 

ALTER USER "sophie@example.com"  quota unlimited on  USERS;
/* END: DBA_Work6 */

/*************************************************************************************************/

/* BEGIN: Employee_Queries7 */

select null as "Employee_Queries7" from dual;

--Outside the normal trusted application path( yet another attempt by Sophie to exfiltrate records but detected in audit_ddl_operations)
connect "sophie@example.com"/&PW
show user;
drop table test_table;
create table test_table as select * from &HCM_USER..employees;  

select * from &HCM_USER..employees;

/* END: Employee_Queries7 */

/*************************************************************************************************/

/* BEGIN: DBA_Work8 */

select null as "DBA_Work8" from dual;

connect "dba_harvey@example.com"/&PW

-- Typical DBA actions. 
select * from dba_users where username = 'lucas@example.com';
select * from dba_role_privs where grantee = 'lucas@example.com';
select * from dba_tab_privs where grantee = 'lucas@example.com';

-- Grant might fail because DBA_HARVEY has not been granted RESOURCE "with admin" option
-- Acceptable failure. 
grant RESOURCE to "lucas@example.com";

-- this grant may fail. DBA_HARVEY does not have the ability to grant this privilege. This is acceptable. 
grant UNLIMITED TABLESPACE to "lucas@example.com";

-- Typical DBA actions
select * from dba_users where username = 'jron@example.com';
select * from dba_role_privs where grantee = 'jron@example.com';
select * from dba_tab_privs where grantee = 'jron@example.com';

/* END: DBA_Work8 */

/*************************************************************************************************/

/* BEGIN: Malicious Work9 by DBA */

select null as "MaliciousWork9" from dual;

-- 
-- This section is intentionally malicious. Someone has stolen Charles' credentials and uses it update the salary of employee henrywil@example.com +samkirk@example.com
-- This memics an attacker probing the database with stolen credentials. There may be a lot of failures in here.
-- 
connect "dba_charles@example.com"/&PW
show user;

select count(*) From dba_objects;
select count(*) from user_objects;

select count(*) from &HCM_USER..EMPLOYEES;

select USERNAME, LAST_INS_CLAIM from &HCM_USER..SUPPLEMENTAL_DATA;

select department_name from &HCM_USER..DEPARTMENTS order by 1;

select JOB_TITLE, MIN_SALARY, MAX_SALARY from &HCM_USER..jobs order by 1;

select * from &HCM_USER..emp_extended where rownum < 10 order by 1;

select * from &HCM_USER..JOBS;
SELECT * from &HCM_USER..JOB_HISTORY;
SELECT * from &HCM_USER..LOCATIONS;

update &HCM_USER..EMPLOYEES set SALARY=99999 where email = 'henrywil@example.com';

select * from &HCM_USER..EMPLOYEES where email = 'henrywil@example.com';
update &HCM_USER..EMPLOYEES set SALARY=23999 where EMAIL='samkirk@example.com';
select * from &HCM_USER..EMPLOYEES where email = 'samkirk@example.com';

commit;

--Then tries to wipe out the audit history---
delete from unified_audit_trail;
truncate table audsys.aud$unified;


/* END: MaliciousWork9 */

/*************************************************************************************************/

/* BEGIN: MaliciousWork10 */

select null as "MaliciousWork10" from dual;

-- 
-- This section is intentionally malicious. 
-- This memics an attacker probing the database with stolen credentials. There may be a lot of failures in here.
-- 
connect &HCM_USER/&PW
show user;

NOAUDIT ALL;

create user APP_TEST identified by Oracle123;    

show user;

SELECT * from &HCM_USER..EMPLOYEES;
SELECT * from &HCM_USER..EMP_EXTENDED;
SELECT * from &HCM_USER..JOBS;
SELECT * from &HCM_USER..JOB_HISTORY;
SELECT * from &HCM_USER..LOCATIONS;

update &HCM_USER..EMPLOYEES set SALARY=14000 where EMAIL='samkirk@example.com';
commit;

select null as "EXPECTED TO ERROR" from dual;
grant DBA to &HCM_USER;

      
/* END: MaliciousWork10 */

/*************************************************************************************************/

/* BEGIN: MaliciousWork11 */

select null as "MaliciousWork11" from dual;

-- 
-- This section is intentionally malicious. 
-- 
connect &HCM_USER/&PW
show user;

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID from &HCM_USER..EMPLOYEES where employee_id = &EMP_ID order by last_name;

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID from &HCM_USER..EMPLOYEES where department_id = &DEPT_ID order by last_name;

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, SALARY,COMMISSION_PCT,MANAGER_ID from &HCM_USER..EMPLOYEES where department_id = &DEPT_ID order by manager_id;

select * from &HCM_USER..emp_extended where employee_id = &EMP_ID;

select * from &HCM_USER..locations where location_id = &LOC_ID;

select LAST_NAME, FIRST_NAME, EMAIL from &HCM_USER..employees where manager_id = &EMP_ID order by 2;

/* END: MaliciousWork11 */

/*************************************************************************************************/


/* BEGIN: DBAWork-12 */

select null as " DBAWork-12- ALL QUERIES EXPECTED TO ERROR" from dual;

connect PDBADMIN/&PW
show user; 


drop profile POWERUSERS;
create profile POWERUSERS limit 
   FAILED_LOGIN_ATTEMPTS 5
   PASSWORD_LIFE_TIME 60
   PASSWORD_REUSE_TIME 60
   PASSWORD_REUSE_MAX 5
   PASSWORD_VERIFY_FUNCTION null
   PASSWORD_LOCK_TIME 1/24
   PASSWORD_GRACE_TIME 10;

ALTER PROFILE default LIMIT 
	FAILED_LOGIN_ATTEMPTS UNLIMITED 
	PASSWORD_GRACE_TIME UNLIMITED  
	PASSWORD_LIFE_TIME UNLIMITED
	PASSWORD_LOCK_TIME UNLIMITED;

-- 
-- You cannot modify profiles on ADB instances. That is acceptable.
ALTER PROFILE APP_PROFILE LIMIT 
	FAILED_LOGIN_ATTEMPTS UNLIMITED 
	PASSWORD_GRACE_TIME UNLIMITED  
	PASSWORD_LIFE_TIME UNLIMITED
	PASSWORD_LOCK_TIME UNLIMITED;

drop user MALFOY cascade;
drop user VOLDEMORT cascade;
drop user GRINDELWALD cascade;
drop user WEASLEY;
drop user LESTRANGE cascade;
drop user SKEETER cascade;
drop user APP_USER cascade;

-- drop and recreate sample users with default passwords (no objects as not needed)
drop user ADAMS cascade;
drop user BLAKE cascade;
drop user CLARK cascade;
drop user HR cascade;

-- This will not work on ADB because of password requirements. That is acceptable.
create user ADAMS identified by wood;
create user BLAKE identified by paper;
create user CLARK identified by cloth;
create user HR identified by hr;
create user IX identified by ix;
create user JONES identified by steel;
create user OE identified by oe;
create user PM identified by pm;
create user SH identified by sh;
create user SCOTT identified by tiger;

-- 18c schema only account
drop user NOAUTH cascade;
create user NOAUTH no authentication;

create user MALFOY identified by &PW;
create user LESTRANGE identified by &PW;
create user SKEETER identified by &PW;
alter user PU_PETE identified by &PW profile POWERUSERS;
create user VOLDEMORT identified by &PW profile POWERUSERS password EXPIRE;
create user GRINDELWALD identified by &PW;
-- Will get privileges to be flagged as Non-Privileged, Medium Risk
create user WEASLEY identified by &PW;
-- User APPX will show up on User Assessment as "Schema" and with Status "Expired & Locked"
create user APPX identified by &PW account lock password expire;
create user APP_USER identified by &PW profile APP_PROFILE;

grant SYSDBA to LESTRANGE;
grant SYSDG to MALFOY;
grant SYSKM to VOLDEMORT;
grant DBA to PUBLIC;
grant DBA to PDBADMIN;
grant DBA to MALFOY;
grant DBA to PU_PETE;
grant DBA to DBA_DEBRA;


grant SELECT ANY TABLE to VOLDEMORT;
grant ALTER DATABASE LINK to WEASLEY;
grant CREATE ANY OPERATOR to WEASLEY;
grant ALTER RESOURCE COST to WEASLEY;
grant CREATE ROLLBACK SEGMENT to WEASLEY;
grant SELECT ANY TABLE to SCOTT;
grant UPDATE ANY TABLE to SCOTT;
grant EXPORT FULL DATABASE to SCOTT;
grant SELECT ANY TABLE to HCM1;
grant UPDATE ANY TABLE to HCM1;
grant DELETE ANY TABLE to HCM2;
create directory BENIGN as '/tmp';
create directory TRUSTME as '/tmp';

-- To highlight indirect privileges

create or replace role approle1; 
create or replace role approle2;
create or replace role approle3;
grant create session to approle1;
grant resource to approle1;
grant select any table to approle2;
grant dba to approle3;
grant approle3 to approle2;
grant approle2 to approle1;
grant approle1 to GRINDELWALD;



drop directory BENIGN;
drop directory TRUSTME;

connect APP_USER/&PW

select * from &HCM_USER..SUPPLEMENTAL_DATA;

/* END:  DBAWork-12 */

/*************************************************************************************************/


/* BEGIN: RegularWork13 */

select null as "RegularWork13" from dual;

-- 
-- This section is is an example of normal DBA, Application, End-user activity.
-- These queries should return successful. No queries should fail. 
--
connect &HCM_USER/&PW
show user;
 
select count(*) From user_tables;
select count(*) from user_objects;

select count(*) from  &HCM_USER..EMPLOYEES;

select department_name from &HCM_USER..DEPARTMENTS order by 1;

select JOB_TITLE, MIN_SALARY, MAX_SALARY from &HCM_USER..jobs order by 1;

select * from &HCM_USER..emp_extended where rownum < 10 order by 1;

/* END: RegularWork13 */

/*************************************************************************************************/

/* BEGIN: RegularHRWork14 */

select null as "RegularHRWork14" from dual;

-- 
-- This section is an example of HR manager normal activity from Application( context set to HR_USER to indicate app activity..so low risk).
--
connect "hr_ann@example.com"/&PW
show user;

def EMP_ID = 181
def LOC_ID = 2900
def DEPT_ID = 80

BEGIN
 set_appuser_pkg.set_context_values('HR_MANAGER');
END;
/
select count(*) from &HCM_USER..EMPLOYEES;

select department_name from &HCM_USER..DEPARTMENTS order by 1;

select count(*), department_id from &HCM_USER..EMPLOYEES group by department_id order by 2;

select job_id, count(*) job_count from &HCM_USER..EMPLOYEES group by job_id;

select JOB_TITLE, MIN_SALARY, MAX_SALARY from &HCM_USER..JOBS order by 1;

select * from &HCM_USER..EMP_EXTENDED where rownum < 10 order by 1;

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID from &HCM_USER..EMPLOYEES where employee_id = &EMP_ID order by last_name;

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID from &HCM_USER..EMPLOYEES where department_id = &DEPT_ID order by last_name;

select employee_id, first_name, last_name, phone_number from &HCM_USER..EMPLOYEES where employee_id = &EMP_ID;
update &HCM_USER..EMPLOYEES set PHONE_NUMBER = '650.670.9800' where employee_id = &EMP_ID;
select employee_id, first_name, last_name, phone_number from &HCM_USER..EMPLOYEES where employee_id = &EMP_ID;

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, SALARY,COMMISSION_PCT,MANAGER_ID from &HCM_USER..EMPLOYEES where department_id = &DEPT_ID order by manager_id;

select * from &HCM_USER..EMP_EXTENDED where employee_id = &EMP_ID;

select * from &HCM_USER..LOCATIONS where location_id = &LOC_ID;

select LAST_NAME, FIRST_NAME, EMAIL from &HCM_USER..EMPLOYEES where manager_id = &EMP_ID order by 2;

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID from &HCM_USER..EMPLOYEES where employee_id = &EMP_ID order by last_name;

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID from &HCM_USER..EMPLOYEES where department_id = &DEPT_ID order by last_name;

select FIRST_NAME, LAST_NAME, EMAIL, PHONE_NUMBER, SALARY,COMMISSION_PCT,MANAGER_ID from &HCM_USER..EMPLOYEES where department_id = &DEPT_ID order by manager_id;

select * from &HCM_USER..EMP_EXTENDED where employee_id = &EMP_ID;

select * from &HCM_USER..LOCATIONS where location_id = &LOC_ID;

select LAST_NAME, FIRST_NAME, EMAIL from &HCM_USER..EMPLOYEES where manager_id = &EMP_ID order by 2;

select LAST_NAME, FIRST_NAME, SALARY from &HCM_USER..EMPLOYEES where employee_id = &EMP_ID;
update &HCM_USER..EMPLOYEES set salary=5000 where employee_id = &EMP_ID;
select LAST_NAME, FIRST_NAME, SALARY from &HCM_USER..EMPLOYEES where employee_id = &EMP_ID;

select * from &HCM_USER..EMP_EXTENDED where employee_id = &EMP_ID;
update &HCM_USER..EMP_EXTENDED set PAYMENTACCOUNTNO = '4321123454326000' where employee_id = &EMP_ID;
select * from &HCM_USER..EMP_EXTENDED where employee_id = &EMP_ID;

select * from &HCM_USER..JOBS where JOB_ID='ST_MAN';
update &HCM_USER..JOBS set MIN_SALARY=5000 where JOB_ID='ST_MAN';

update &HCM_USER..REGIONS set REGION_NAME='EMEA' where REGION_ID=4;
comment on column &HCM_USER..EMPLOYEES.EMPLOYEE_ID is 'This is the unqiue employee identifier.';
commit;

/* END: RegularHRWork14 */

/*************************************************************************************************/

/* BEGIN: RegularWork15 */

select null as "RegularWork15" from dual;
def EMP_ID = 181
def LOC_ID = 2900
def DEPT_ID = 80
-- 
-- This section is is an example of normal HR User activity
-- These queries should return successful. No queries should fail. 
--
connect "hr_lan@example.com"/&PW
show user;
BEGIN
 set_appuser_pkg.set_context_values('HR_USER');
END;
/
select employee_id, paymentaccountno from &HCM_USER..emp_extended where employee_id = &EMP_ID;
update &HCM_USER..emp_extended set PAYMENTACCOUNTNO = PAYMENTACCOUNTNO-&EMP_ID where employee_id = &EMP_ID;
select employee_id, paymentaccountno from &HCM_USER..emp_extended where employee_id = &EMP_ID;

rollback;

select employee_id, paymentaccountno from &HCM_USER..emp_extended where employee_id = &EMP_ID;
update &HCM_USER..emp_extended set PAYMENTACCOUNTNO = PAYMENTACCOUNTNO where employee_id = &EMP_ID;
select employee_id, paymentaccountno from &HCM_USER..emp_extended where employee_id = &EMP_ID;

select LAST_INS_CLAIM from &HCM_USER..SUPPLEMENTAL_DATA where PERSON_ID = &EMP_ID;
UPDATE &HCM_USER..SUPPLEMENTAL_DATA set LAST_INS_CLAIM=1000 where PERSON_ID =&EMP_ID;


commit;

/* END: RegularWork15 */

/*************************************************************************************************/

/* BEGIN: MaliciousHRWork16 */

--DBA accidentally grants extra privileges to hr_jim@example.com and he can do updates on JOBS/REGIONS from the apps. 
select null as "MaliciousHRWork16" from dual;

connect "dba_debra@example.com"/&PW
show user;
GRANT ALL ON &HCM_USER..JOBS to "hr_jim@example.com";

def EMP_ID = 181
def LOC_ID = 2900
def DEPT_ID = 80
-- 
-- This section is is an example of malicious HR User activity
-- These queries should return successful. No queries should fail. 
--


connect "hr_jim@example.com"/&PW
show user;
BEGIN
 set_appuser_pkg.set_context_values('HR_USER');
END;
/
select employee_id, paymentaccountno from &HCM_USER..emp_extended where employee_id = &EMP_ID;
update &HCM_USER..emp_extended set PAYMENTACCOUNTNO = PAYMENTACCOUNTNO-&EMP_ID where employee_id = &EMP_ID;
select employee_id, paymentaccountno from &HCM_USER..emp_extended where employee_id = &EMP_ID;

rollback;

select employee_id, paymentaccountno from &HCM_USER..emp_extended where employee_id = &EMP_ID;
update &HCM_USER..emp_extended set PAYMENTACCOUNTNO = PAYMENTACCOUNTNO where employee_id = &EMP_ID;
select employee_id, paymentaccountno from &HCM_USER..emp_extended where employee_id = &EMP_ID;

select LAST_INS_CLAIM from &HCM_USER..SUPPLEMENTAL_DATA where PERSON_ID = &EMP_ID;
UPDATE &HCM_USER..SUPPLEMENTAL_DATA set LAST_INS_CLAIM=1000 where PERSON_ID =&EMP_ID;

select * from &HCM_USER..JOBS;
UPDATE &HCM_USER..JOBS set MIN_SALARY=1000;

update &HCM_USER..REGIONS set REGION_NAME='EMEA' where REGION_ID=4;

rollback;
 --DBA realizes it late and revokes it later but the damage had occured.
connect "dba_debra@example.com"/&PW
show user;
REVOKE ALL ON &HCM_USER..JOBS from "hr_jim@example.com";


 /* END: MaliciousHRWork16 */
 /*************************************************************************************************/

/* BEGIN: BadLogin17 */

select null as "BadLogin17" from dual;

--
-- Intentionally causing failed logins to show up in the Audit Trails

--
connect "dba_debra@example.com"/badpass
connect "dba_harvey@example.com"/badpass
connect &HCM_USER/badpass
connect &HCM_USER/badpass
connect system/badpass
connect "hr_lan@example.com"/badpass
connect sys/badpass

/* END: BadLogin17 */

 /*************************************************************************************************/

/* BEGIN: MaliciousWork18 */

select null as "MaliciousWork18" from dual;

--
-- Someone stole the HR manager's hr_ann@example.com credentials and tries to delete employee data using trusted path


connect "hr_ann@example.com"/&PW
show user;
BEGIN
 set_appuser_pkg.set_context_values('HR_USER');
END;
/

delete from HCM.SUPPLEMENTAL_DATA where PERSON_ID=100;
delete from HCM.EMP_EXTENDED where EMPLOYEE_ID=100;

rollback;
/* END: MaliciousWork18 */
/*************************************************************************************************/

/* BEGIN: MaliciousWorkByEmpLucas19 */

select null as "MaliciousWorkByEmpLucas19" from dual;
-- Lucas compromises Security admin's credential 

connect "lucas@example.com"/&PW
show user;


--Power security admin's credential is compromised by Lucas after multiple failed login attempts 

connect "secadmin_steve@example.com"/Welcome_5
connect "secadmin_steve@example.com"/Welcome_4
connect "secadmin_steve@example.com"/Welcome_3
connect "secadmin_steve@example.com"/Welcome_2
connect "secadmin_steve@example.com"/Welcome_0
connect "secadmin_steve@example.com"/Welcome_1
show user;

connect "lucas@example.com"/&PW
show user;
-- Uses trusted path to escape detection
BEGIN
 set_appuser_pkg.set_context_values('EMPLOYEE_USER');
END;
/

select * from HCM.EMPLOYEES;

/* END: MaliciousWorkByEmpLucas19*/

/*************************************************************************************************/

