Rem oracle_audit_trail_cleanup.sql
Rem
Rem Copyright  2020, Oracle and/or its affiliates. All rights reserved. This script is provided for educational purposes only and are not intended for production use, and the contents hereof are subject to change without notice. This script is not warranted to be error-free, nor subject to any other warranties or conditions, whether expressed orally or implied in law, including implied warranties and conditions of merchantability or fitness for a particular purpose. We specifically disclaim any liability with respect to this script, and no contractual obligations are formed either directly or indirectly by this script. 
Rem
Rem    NAME
Rem      oracle_audit_trail_cleanup.sql - Cleanup script used for HR target in AVDF20 cookbook
Rem
Rem    DESCRIPTION
Rem      This scripts creates a purge job to clean up audit records at source periodically
Rem      AVDF agent calls DBMS_AUDIT_MGMNT. SET_LAST_ARCHIVE_TIMESTAMP after it sets the checkpoint in AVS, and this purge job whenever it wakes up - it reads the last archive timstamp before periodically deleting the audit trail records.
Rem
Rem    NOTES
Rem      You will need to enter the sys password as parameter when prompted
Rem       Run this script on the database instance where HCM user schema is configured
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    adhanara    07/28/20 - Created
Rem


/*************************************************************************************************/

connect sys/&SYSPASSWORD as sysdba

BEGIN
 DBMS_AUDIT_MGMT.INIT_CLEANUP(
  AUDIT_TRAIL_TYPE            => DBMS_AUDIT_MGMT.AUDIT_TRAIL_ALL,
  DEFAULT_CLEANUP_INTERVAL    => 1 );
END;
/

BEGIN
  DBMS_AUDIT_MGMT.CREATE_PURGE_JOB (
   AUDIT_TRAIL_TYPE            => DBMS_AUDIT_MGMT.AUDIT_TRAIL_ALL,
   AUDIT_TRAIL_PURGE_INTERVAL  => 1,
   AUDIT_TRAIL_PURGE_NAME      => 'CLEANUP_OS_DB_AUDIT_RECORDS',
   USE_LAST_ARCH_TIMESTAMP     => TRUE );
END;
/