package adf.sample;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

import oracle.adf.controller.ControllerContext;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.view.rich.component.rich.data.RichTable;
import oracle.adf.view.rich.context.AdfFacesContext;

import oracle.jbo.Row;
import oracle.jbo.uicli.binding.JUCtrlHierBinding;
import oracle.jbo.uicli.binding.JUCtrlHierNodeBinding;

import org.apache.myfaces.trinidad.event.SelectionEvent;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.RowKeySet;


public class TablePageBean {
    public TablePageBean() {
    }

    /**
     * Handle single row selection use case. If the previous row contains
     * uncommitted data, undo row selection and inform user that he/she
     * should commit a value change before editing the next row
     * @param selectionEvent
     */
    public void onTableSelect(SelectionEvent selectionEvent) {
        //keep track of (old) selected row key
        RowKeySet oldKeySet = selectionEvent.getRemovedSet();

        //until here only the row selection in the table has changed. The ADF
        //binding layer doesn't know about the row selection yet. If there is
        //uncommitted data then we don't change current row on the binding and
        //just set the table key back

        RichTable table = (RichTable)selectionEvent.getSource();

        //From the table, get the associated ADF tree binding. This handle
        //is used later to set the current row in the binding to the row
        //selected in the ADF Faces table.

        CollectionModel tableModel = (CollectionModel)table.getValue();
        JUCtrlHierBinding adfTableBinding = (JUCtrlHierBinding) tableModel.getWrappedData();

        //read the transaction state from the controller context. This way we
        //do have it easy to use this code in a bounded task flow too even if
        //the task flow doesn't share the data control instance with its parent
        ControllerContext cctx = ControllerContext.getInstance();
        if(cctx.getCurrentViewPort().isDataDirty()){
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO,
                                                    "Please Commit Changes",
                                                    "Changes must be committed before selecting a new table row");
            FacesContext fctx = FacesContext.getCurrentInstance();
            fctx.addMessage(null, message);

            table.setSelectedRowKeys(oldKeySet);
            AdfFacesContext adfFacesCtx = AdfFacesContext.getCurrentInstance();
            //refresh table to show current selected row set back to original row.
            //Note that though we set the row back, no row selection event is fired.
            //Row selection events fire only if users select a row

            adfFacesCtx.addPartialTarget(table);
            fctx.renderResponse();
        }
        else{
            //Next: Make the selected table row the current row in the ADF binding
            //layer. The code below is the substitution of the default SelectionListener
            //definition JDevelopert set to #{bindings.DepartmentsVie1.makeCurrent}
            //or, put in more generic terms, #{bindings.<tree binding Id>.makeCurrent}
            JUCtrlHierNodeBinding tableRowBinding = (JUCtrlHierNodeBinding) table.getSelectedRowData();
            Row row = tableRowBinding.getRow();
            //get access to the iterator that is used by teh table binding
            DCIteratorBinding iter = adfTableBinding.getDCIteratorBinding();
            //set the row rterieved from the table as the current row
            iter.getRowSetIterator().setCurrentRow(row);
            //no need to refresh the ADF Faces table because table and binding
            //are in synch
        }

    }
}
