package adf.sample.view.beans;

import java.util.ArrayList;
import java.util.List;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import oracle.adf.model.BindingContext;

import oracle.binding.BindingContainer;

import oracle.jbo.Row;
import oracle.jbo.domain.Number;
import oracle.jbo.uicli.binding.JUCtrlListBinding;

/**
 * Managed bean in view scope to reduce the refresh rate for the list data. A 
 * bean in request scope would fetch the data on each partial reresh 
 */
public class SelectManyHelperBean {
    //original list item queried from the ADF binding layer
    List<SelectItem> selectItemList = null;
    //select list with enabled/disabled item state rendered on view
    ArrayList<SelectItem> newSelectItemList = null;
    //to avoid unnecessary refreshes, we check if the selected Location in the 
    //location list item has changed. If not then we don't process the deparments
    //list
    Object currentLocationId = null;
    
    public SelectManyHelperBean() {
        super();
    }

    public void setSelectItemList(List<SelectItem> selectItemList) {}

    /**
     * Queries the list data from the ADF bindin layer and returns the list 
     * with disabled set to tru or false dependent on whether displayed item
     * is in location or not
     * @return List<SelectItem>
     */
    public List<SelectItem> getSelectItemList() {        
        //Create Value Expression to access the ADF list for he departments 
        //select many checkbox
        FacesContext fctx = FacesContext.getCurrentInstance();
        ELContext elctx = fctx.getELContext();
        ExpressionFactory exprfact = fctx.getApplication().getExpressionFactory();
        ValueExpression vexpr = exprfact.createValueExpression(
                                          elctx, 
                                          "#{bindings.allDepartments.items}",
                                          Object.class);
        selectItemList = (List<SelectItem>) vexpr.getValue(elctx);
        
        /*
         * START: Disable all departments that are not in the selected location        
         */
        BindingContext bctx = BindingContext.getCurrent();
        BindingContainer bindings = bctx.getCurrentBindingsEntry();
        //get access to the Locations list to determine the current location 
        JUCtrlListBinding locationListBinding = (JUCtrlListBinding) bindings.get("allLocations");        
        Row selectedListRow = locationListBinding.getCurrentRow();
        //get the location ID value to compare with the Departments list
        //item LocationId
        Object locationId = selectedListRow.getAttribute("LocationId");
        //only refresh list if location id has changed
        if(locationId != currentLocationId){
            //access the department list items to display in the select many
            //checkbox choice
            JUCtrlListBinding deptListBinding = (JUCtrlListBinding) bindings.get("allDepartments");
            //we need to copy the list items into a new list and return this to 
            //the select many component as the list read from the ADF binding 
            //layer appears to be immutable
            newSelectItemList = new ArrayList<SelectItem>();
            //for each item in the list of departments, check if the locationId
            //is the same as the selected locationId. If so, enable check box
            for(SelectItem li : selectItemList){
                //the departments list queried from the ADF binding layer only
                //returns a list of indx that we need to resolve to determine
                //the department select items LocationId
                Integer listIndex = (Integer) li.getValue();
                Row deptListRow = deptListBinding.getRowAtRangeIndex(listIndex.intValue());
                
                //create a new select item to add to the modified list of
                //departments
                SelectItem s = new SelectItem();
                s.setLabel(li.getLabel());
                s.setValue(li.getValue());
                
                //determine if the item should be enabled or disabled
                if(((Number) deptListRow.getAttribute("LocationId")).equals((Number)locationId)) {                    
                    s.setDisabled(false);
                }
                else{
                    s.setDisabled(true);
                }
                //add item to list
                newSelectItemList.add(s);
            }    
        }
        //make sure the current locationId is saved for later comparison. If the
        //location id doesn't change then the list is not refreshed. Remember that
        //the managed bean is in view scope
        locationId = currentLocationId;
        //return the modified list
        return newSelectItemList;
    }
}
