package adf.sample;

import java.util.Iterator;
import java.util.List;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.view.rich.component.rich.data.RichTable;
import oracle.adf.view.rich.component.rich.input.RichInputText;
import oracle.adf.view.rich.component.rich.layout.RichPanelFormLayout;
import oracle.adf.view.rich.datatransfer.DataFlavor;
import oracle.adf.view.rich.datatransfer.Transferable;
import oracle.adf.view.rich.dnd.DnDAction;
import oracle.adf.view.rich.event.DropEvent;

import oracle.binding.BindingContainer;

import oracle.jbo.Row;
import oracle.jbo.uicli.binding.JUCtrlHierNodeBinding;

import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.render.ExtendedRenderKitService;
import org.apache.myfaces.trinidad.util.Service;


/**
 * Drag and drop handler that handles the table row drop onto an input form
 *
 * @author Frank Nimphius (8/2012)
 */
public class DropHandlerBean {


    public DropHandlerBean() {
    }

    public DnDAction dropHandler(DropEvent dropEvent) {

        //access the drag source, the table to read the rowKey
        //representing the row
        RichTable table = (RichTable)dropEvent.getDragComponent();
        Transferable t = dropEvent.getTransferable();

        DataFlavor<RowKeySet> df =  DataFlavor.getDataFlavor(RowKeySet.class,"rowcopy");
        RowKeySet rks = t.getData(df);
        Iterator iter = rks.iterator();

        //sample is set up for single row drag and drop
        if (iter.hasNext()) {

            //get next selected row key
            List key = (List)iter.next();
            table.setRowKey(key);

            //drop component
            RichPanelFormLayout panelFormLayout = (RichPanelFormLayout) dropEvent.getDropComponent();

            //JUCtrlHierNodeBinding is the object in ADF that represens a row in a table
            //or a node in a tree. The object wraps the actual table row object, which in
            //the case of ADF BC is oracle.jbo.Row
            JUCtrlHierNodeBinding rowBinding = (JUCtrlHierNodeBinding)table.getRowData();
            Row departmentDropRow = rowBinding.getRow();

            //update current row in form if the table row is not null
            if(departmentDropRow != null){
                //get handle to drop component
                UIComponent managerId = null;

                for(UIComponent uiComp : panelFormLayout.getChildren()){
                    if(uiComp.getId()=="it8"){
                        ((RichInputText)uiComp).resetValue();
                        ((RichInputText)uiComp).setValue(departmentDropRow.getAttribute("DepartmentId"));
                    }
                    else if(uiComp.getId()=="it2"){
                        managerId = uiComp;
                    }
                }

               //access current binding container
               BindingContext bctx = BindingContext.getCurrent();
               BindingContainer bindings = bctx.getCurrentBindingsEntry();
               //get current employee row
               DCIteratorBinding employeeIterator =
                   (DCIteratorBinding) bindings.get("EmployeesView1Iterator");
               Row currentEmployee = employeeIterator.getCurrentRow();

                //managers should not manage themselves
               oracle.jbo.domain.Number employeeId =
                   (oracle.jbo.domain.Number) currentEmployee.getAttribute("EmployeeId");
               oracle.jbo.domain.Number deptManagerId =
                   (oracle.jbo.domain.Number)departmentDropRow.getAttribute("ManagerId");

                if(employeeId == null || (employeeId.intValue() != deptManagerId.intValue())){
                     ((RichInputText)managerId).resetValue();
                     ((RichInputText)managerId).setValue(departmentDropRow.getAttribute("ManagerId"));
                }
            }

            //at the end of the drag and drop operation, the drop target, the
            //panelFormLayout in this case is refreshed. If the form you edit
            //with drag and drop contains required fields, then these would be
            //flagged as an error. To avoid this, JavaScript is used to clear
            //all error messages on the client side

            FacesContext fctx = FacesContext.getCurrentInstance();
            ExtendedRenderKitService erks =
                Service.getRenderKitService(fctx, ExtendedRenderKitService.class);
            erks.addScript(fctx,"AdfPage.PAGE.clearAllMessages();");
            return DnDAction.COPY;
           }
        return DnDAction.NONE;
    }
}
