package adf.sample.view;

import javax.faces.context.FacesContext;

import oracle.adf.view.rich.component.rich.RichPopup;
import oracle.adf.view.rich.component.rich.layout.RichShowDetailItem;
import oracle.adf.view.rich.render.ClientEvent;

import org.apache.myfaces.trinidad.render.ExtendedRenderKitService;
import org.apache.myfaces.trinidad.util.Service;


/**
 * Managed bean called from the client to check whether user panel tab switch is acceptable or if
 * there exist reason to ask the user if he/she really wants to leave the current tab. The sample
 * also contains client side code in its TabView.jsff page that would allow you to perform the dialog
 * open decision on the client side (e.g based on the outcome of a client side verification
 *
 *  @author Frank Nimphius, 2012
 */
public class DialogHandlerBean {
    
    //JSF component reference to the popup to open. The managed bean is in backing bean scope so that 
    //component references are okay
    private RichPopup popupP1;

    public DialogHandlerBean() {
    }

    //the af:serverListener defined on each af:showDetailItem component in TabView.jsff calls the server 
    //when the user clicks on a disclosed tab. The information contained in the call contains a reference
    //to the RichShowDetailComponent. This is automatically done by the af:serverListener referencing the 
    //client side tab instance    
    public void onCheckDialogOpen(ClientEvent clientEvent) {
        
        //do we need to challenge the user ?
        boolean tabSwitchOk = false;
        //get the tab that has been pressed to navigate to
        RichShowDetailItem tab = (RichShowDetailItem) clientEvent.getComponent();
        
        /* ****YOUR TODO ************** */
        
        //Check if tab switch is ok or if the user needs to be asked. For example, the 
        //ControllerContext class gives you access to the ViewPortContext that exposes 
        //an API to check if the transaction is dirty ....
        
        //tabSwitchOk = <your checking code here>
        /* ****END YOUR TODO *********** */
        
        
        //the Trinidad ExtendedRenderKitService allows you to write JavaScript command to the 
        //client with the response issued in return to the af:serverListener call
        FacesContext fctx = FacesContext.getCurrentInstance();            
        ExtendedRenderKitService erks = Service.getRenderKitService(fctx, ExtendedRenderKitService.class);
        
        //if tab switch is false, show a popup dialog for the user to decide whether to navigate off the 
        //current tab or stay (e.g. to provide additional information)
        if (tabSwitchOk != true) {
            
            String tabId = tab.getClientId();         
            
            //compose the JS that accesses the client side popup instance and shows it. A client side property 
            //is set to the af:clientAttribute defined on the af:popup component to pass the tab Id to navigate 
            //to the command button in the dialog
            String showDialogScript =
                "var popup = AdfPage.PAGE.findComponentByAbsoluteId('" + popupP1.getClientId() + "'); popup.show();" +
                "popup.setProperty('tabToOpen','" + tabId + "')";
            erks.addScript(fctx, showDialogScript);
        }
        else{
            String noDialogScript = "var tab = AdfPage.PAGE.findComponentByAbsoluteId('"+tab.getClientId()+"');" + 
                                    "tab.setDisclosed(true);";
            erks.addScript(fctx, noDialogScript);
        }
    }

    public void setPopupP1(RichPopup popupP1) {
        this.popupP1 = popupP1;
    }

    public RichPopup getPopupP1() {
        return popupP1;
    }
}
