package adf.interactiv.model.queries;


import adf.interactiv.model.queries.common.EmployeesView;

import java.util.List;

import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowSetImpl;


// ---------------------------------------------------------------------
// ---    File generated by Oracle ADF Business Components Design Time.
// ---    Mon May 25 09:28:55 CEST 2009
// ---    Custom code may be added to this class.
// ---    Warning: Do not modify method signatures of generated methods.
// ---------------------------------------------------------------------
public class EmployeesViewImpl extends ViewObjectImpl implements EmployeesView {
    /**
     * This is the default constructor (do not remove).
     */
    public EmployeesViewImpl() {
    }
    
    /**
     * Method that performs a bulk delete of all employees that are 
     * referenced by the keys in the list
     * @param employees The list of employee keys
     * @return void. 
     */
    public void processEmployeeBulkDelete(List employees){   
        System.out.println("HERE !!!");
        if (employees != null){
            for (Object employee : employees) {
                Key k = (Key)employee;
                Row[] rowsFound = this.findByKey(k,1);
                //if the key returns more than one row then its obviously not
                //unique. This cases is ignored in this sample
                if (rowsFound != null && rowsFound.length == 1) {
                    //get the first entry in the array of rows found
                    Row employeeRow = rowsFound[0];
                    employeeRow.remove();
                }
            }
        }        
    }
    
    public void copyRows(){
       ViewRowSetImpl vrs =  (ViewRowSetImpl) this.deepCopy(null, RowSet.COPY_OPT_LIMIT_RANGE);
       
       int pkStart = 850;
       int i = 0;
       RowSetIterator rowIterator = vrs.getRowSetIterator();
       while(rowIterator.hasNext()){
        ++i;
        Row rw = (Row)rowIterator.next();
        rw.setAttribute("EmployeeId", pkStart+i);             
       }
       this.addRowSet(vrs);
    }
}
