package adf.interactiv;

import java.util.ArrayList;

import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.view.rich.component.rich.data.RichTable;
import oracle.adf.view.rich.context.AdfFacesContext;

import oracle.jbo.Key;
import oracle.jbo.uicli.binding.JUCtrlHierBinding;
import oracle.jbo.uicli.binding.JUCtrlHierNodeBinding;

import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.RowKeySetImpl;
import org.apache.myfaces.trinidad.render.ExtendedRenderKitService;
import org.apache.myfaces.trinidad.util.Service;


public class SearchRowBean {

    Integer rowNumber = 1;
    private RichTable table1;

    public SearchRowBean() {
    }

    public void onRowSearch(ActionEvent actionEvent) {
        
        //get the table model
        CollectionModel collectionModel = (CollectionModel)table1.getValue();
        //the table model - CollectionModel - wraps the ADF tre binding for this table
        JUCtrlHierBinding tableBinding = (JUCtrlHierBinding) collectionModel.getWrappedData();
        //get the iterator for the tree binding
        DCIteratorBinding iteratorBinding = tableBinding.getIteratorBinding();
        //from the table instance itself, get the requested row number
        JUCtrlHierNodeBinding rowBinding = (JUCtrlHierNodeBinding) table1.getRowData(rowNumber-1);
        //from the node binding, get the JBO rowKey
        Key rowKey = rowBinding.getRow().getKey();
        //make the searched row the current
        iteratorBinding.setCurrentRowWithKey(rowKey.toStringFormat(true));
        //create a new table rowKey (the RichTable row key is different from JBO Key
        ArrayList tableRowKey = new ArrayList();
        tableRowKey.add(rowKey);
        RowKeySetImpl rks = new RowKeySetImpl();
        rks.add(tableRowKey);
        table1.setSelectedRowKeys(rks);
        //close the search dialog
        closePopup("p1");        
        //refresh table
        AdfFacesContext.getCurrentInstance().addPartialTarget(table1);
    }
    
    private void closePopup(String popup) {
      FacesContext fctx = FacesContext.getCurrentInstance();
      //create the JaavScript expressions
      StringBuffer scriptBuffer = new StringBuffer();
      scriptBuffer.append(
           "var popup = AdfPage.PAGE.findComponentByAbsoluteId('");
      scriptBuffer.append(popup+"');");
      scriptBuffer.append("if(popup.isPopupVisible()==true){");
      scriptBuffer.append("popup.hide();}");       
      String script = scriptBuffer.toString();
      //execute the script on the client
      ExtendedRenderKitService extendedRenderKitService =   
         Service.getRenderKitService(fctx,ExtendedRenderKitService.class);
      extendedRenderKitService.addScript(fctx,script);
    }


    public void setRowNumber(Integer rowNumber) {
        this.rowNumber = rowNumber;
    }

    public Integer getRowNumber() {
        return rowNumber;
    }

    public void setTable1(RichTable table1) {
        this.table1 = table1;
    }

    public RichTable getTable1() {
        return table1;
    }
}
