package adf.sample;

import java.util.Map;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;

import javax.faces.context.FacesContext;

import oracle.adf.view.rich.event.QueryEvent;
import oracle.adf.view.rich.model.FilterableQueryDescriptor;


public class QueryFilterBean {
    public QueryFilterBean() {
    }
    public void onQuery(QueryEvent queryEvent) {
        
        // pre-processing code here        
        
        boolean invokeQuery = true;

        FilterableQueryDescriptor fqd = (FilterableQueryDescriptor) queryEvent.getDescriptor();
        Map map = fqd.getFilterCriteria();
        
        // ensure DepartmentId contains a Number
        String departmentId = (String) map.get("DepartmentId");
        
        if (departmentId != null && departmentId.length()>0){
            
            try {
              // try to parse String to integer
               Long.parseLong(departmentId);
                
            } catch (Exception ex) {
                // not a string
                System.out.println("Not a string");
                // add some error message here
                // unset selection
                map.remove("DepartmentId");
                invokeQuery = false;
            } 
        }
                
        // ensure the initial character is in uppercase
        String departmentName = (String) map.get("DepartmentName");
        if (departmentName != null && departmentName.length()>0){
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(departmentName.substring(0,1).toUpperCase());
            sbuf.append(departmentName.substring(1).toLowerCase());
            map.put("DepartmentName",sbuf.toString());            
        }
                        
        if (invokeQuery) {
            invokeMethodExpression("#{bindings.DepartmentsView1Query.processQuery}",
                                                   Object.class,QueryEvent.class,
                                                   queryEvent);
        }

        // post processing code here
        
    }    
    
       public Object invokeMethodExpression(String expr, Class returnType, Class[] argTypes,Object[] args){
               FacesContext fc = FacesContext.getCurrentInstance();       
               ELContext elctx  = fc.getELContext();
               ExpressionFactory elFactory = fc.getApplication().getExpressionFactory();       
               MethodExpression methodExpr = elFactory.createMethodExpression(elctx,expr,returnType,argTypes);       
               return methodExpr.invoke(elctx,args);       
           }
          
           public Object invokeMethodExpression(String expr, Class returnType,Class argType, Object argument){     
               return invokeMethodExpression(expr, returnType,new Class[]{argType}, new Object[]{argument});
           }
 }
