/*
 * Decompiled with CFR 0.152.
 */
package adf.sample.poicc.servlet;

import java.io.IOException;
import java.security.Permission;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.SecurityContext;
import oracle.security.jps.ResourcePermission;

public class DynamicSiteCCFilter
implements Filter {
    private FilterConfig _filterConfig = null;
    final String ACTION = "override";
    final String RESOURCE_NAME = "adf.sample.cc.Site";
    final String RESOURCE_TYPE = "Customization";
    final String SITE_URL_PARAM = "siteCC";
    final String SITE_CC_SESSION_ATTIBUTE = "adf.sample.cc.SiteCC.value";

    public void init(FilterConfig filterConfig) throws ServletException {
        this._filterConfig = filterConfig;
    }

    public void destroy() {
        this._filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest _req = (HttpServletRequest)request;
        HttpSession _session = _req.getSession(false);
        String siteCCUrlParam = _req.getParameter("siteCC");
        if (siteCCUrlParam != null && this.isAllowedOverride()) {
            if (siteCCUrlParam.equalsIgnoreCase("RESET")) {
                _session.removeAttribute("adf.sample.cc.SiteCC.value");
            } else {
                _session.setAttribute("adf.sample.cc.SiteCC.value", (Object)siteCCUrlParam);
            }
        }
        chain.doFilter(request, response);
    }

    private boolean isAllowedOverride() {
        boolean hasPermissionGranted = false;
        ADFContext adfCtx = ADFContext.getCurrent();
        SecurityContext securityCtx = adfCtx.getSecurityContext();
        ResourcePermission sitePermission = null;
        sitePermission = new ResourcePermission("Customization", "adf.sample.cc.Site", "override");
        hasPermissionGranted = securityCtx.hasPermission((Permission)sitePermission);
        return hasPermissionGranted;
    }
}

