package adf.sample.srvltctx.cc;


import adf.sample.pwusr.cc.PowerUserCC;

import javax.servlet.ServletContext;

import oracle.mds.core.MetadataObject;
import oracle.mds.core.RestrictedSession;
import oracle.mds.core.SessionOptions;


/**
 * Extended version of the PowerUserCC class. Using a servlet context parameter 
 * "adf.sample.cc.PowerUser" administrators can configure an application to start 
 * in power user mode or in normal mode. Session settings of the UserCC class later 
 * on override the web.xml configuration. 
 *
 * <context-param>
 *   <param-name>adf.sample.cc.PowerUser</param-name>
 *   <param-value>true</param-value>
 * </context-param>
 *
 * This context parameter can be overridden by a session attribute adf.sample.pwrusr.POWER_USER set
 * to true or false. If the attribute is missing then the servlet context information alone is used
 * to determine the user type
 */
public class PowerUserWithCtxDefaultCC extends PowerUserCC{
    
    final String contextParameter = "adf.sample.cc.PowerUser";
    
    public PowerUserWithCtxDefaultCC() {
        super();
    }

    public String[] getValue(RestrictedSession restrictedSession,
                             MetadataObject metadataObject) {
        
        //accessing the MDS session
        SessionOptions so = restrictedSession.getSessionOptions();
        ServletContext servletContext = null;
        servletContext = (ServletContext) so.getServletContextAsObject();
        
        //context parameter checking       
        Object powerUserServletContextFlag = null;
        powerUserServletContextFlag = servletContext.getInitParameter(contextParameter);
        boolean isCtxPowerUser = powerUserServletContextFlag == null? false : 
                                 ((String)powerUserServletContextFlag).equalsIgnoreCase("true")? 
                                 true :false;
        return getValue(restrictedSession,metadataObject,isCtxPowerUser);
    }
}
