package adf.sample.poicc.servlet;


import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import javax.servlet.http.HttpSession;

import oracle.adf.share.ADFContext;
import oracle.adf.share.security.SecurityContext;

import oracle.security.jps.ResourcePermission;


/**
 *
 * Filter analyzing the URL request parameters for the "siteCC" parameter. If the
 * parameter is found, the authenticated user session is checked if authorized to
 * write to the MDS session object.
 *
 * <permission>
 * <class>oracle.security.jps.ResourcePermission</class>
 * <name>resourceType=Customization,resourceName=adf.sample.cc.Site</name>
 * <actions>override</actions>
 * </permission>
 *
 * The permission must be configured in the jazn-data.xml file of the application and
 * is checked using the ADF Security Context. It is important that this filter is
 * configured after the ADF binding filter so that the binding contxt exists when this
 * filter executes.
 *
 * ... ADF filter config ...
 *
 * <filter>
 * <filter-name>DynamicSiteCCFilter</filter-name>
 * <filter-class>adf.sample.poicc.servlet.DynamicSiteCCFilter</filter-class>
 * </filter>
 * ...
 * ... ADF filter config mapping ...
 *
 * <filter-mapping>
 * <filter-name>DynamicSiteCCFilter</filter-name>
 * <url-pattern>/faces/*</url-pattern>
 * </filter-mapping>
 *
 *
 */
public class DynamicSiteCCFilter implements Filter {
    private FilterConfig _filterConfig = null;
    
    final String ACTION = "override";
    final String RESOURCE_NAME = "adf.sample.cc.Site";
    final String RESOURCE_TYPE = "Customization";
    
    final String SITE_URL_PARAM = "siteCC";
    final String SITE_CC_SESSION_ATTIBUTE = "adf.sample.cc.SiteCC.value";

    public void init(FilterConfig filterConfig) throws ServletException {
        _filterConfig = filterConfig;
    }

    public void destroy() {
        _filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response,
                         FilterChain chain) throws IOException,
                                                   ServletException {
        
        //check if siteCC parameter is on the request URL
        HttpServletRequest _req = (HttpServletRequest) request;
        HttpSession _session = _req.getSession(false);
        Object siteCCUrlParam = _req.getParameter(SITE_URL_PARAM);
        
        
        if(siteCCUrlParam!= null && isAllowedOverride()){
            if(((String)siteCCUrlParam).equalsIgnoreCase("RESET")){
                _session.removeAttribute(SITE_CC_SESSION_ATTIBUTE);
            }
            else{
                _session.setAttribute(SITE_CC_SESSION_ATTIBUTE,siteCCUrlParam);
            }
        }
        
        chain.doFilter(request, response);
    }
    
    private boolean isAllowedOverride(){        
      boolean hasPermissionGranted = false;
      ADFContext adfCtx = ADFContext.getCurrent();
      SecurityContext securityCtx = adfCtx.getSecurityContext();        
      ResourcePermission sitePermission = null;
      sitePermission = new ResourcePermission(RESOURCE_TYPE,RESOURCE_NAME,ACTION);        
      hasPermissionGranted = securityCtx.hasPermission(sitePermission);    
      return hasPermissionGranted;
    }
}
