package adf.sample.pwusr.cc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import oracle.adf.share.ADFContext;

import oracle.mds.core.MetadataObject;
import oracle.mds.core.RestrictedSession;
import oracle.mds.cust.CacheHint;
import oracle.mds.cust.CustomizationClass;


/*
 * Customization layer that supports application customization for
 * power users and average users. Power users are expert users that
 * require type ahead optimized UI and don't need help from list of
 * values or similar "click" features. This customization class looks
 * for a specific adf.sample.pwrusr.USER_TYPE session parameter in the
 * user session to apply customization.
 *
 */
public class PowerUserCC extends CustomizationClass {
    
    //define variable as static so it can be discovered
    public static final String USER_TYPE_PARAMETER = "adf.sample.pwrusr.POWER_USER";
    public static final String PowerUserLayerName = "poweruser";
    
    public PowerUserCC() {
        super();
    }

    //customization is for all power users
    public CacheHint getCacheHint() {
        return CacheHint.ALL_USERS;
    }

    public String getName() {
        return "powerUserCC";
    }

    boolean isPowerUser = false;
    
    //internal method to be used by subclasses that define a smart default for
    //the power user default setting. This smart default may be read from the
    //servlet context, a properties file, the RDBMS or conditional from another
    //variable
    protected String[] getValue(RestrictedSession restrictedSession,
                                MetadataObject metadataObject,
                                boolean powerUserTheDefault) {
        isPowerUser =  powerUserTheDefault;
        //restricted session and metadataObject is not used in this
        //method. 
        return getUserType();
    }

    public String[] getValue(RestrictedSession restrictedSession,
                             MetadataObject metadataObject) {
        //restricted session and metadataObject is not used in this
        //method. 
        return getUserType();
    }

    /**
     * Method to determine if the application instance runs in power user mode. The 
     * power user mode is enabled through a an attribute in the user session. Note 
     * that for this customization, there is no need for the user to be authenticated. 
     * @return String[] with length 0 if user runsin normal mode, or value "poweruser" if 
     * application runs in power user mode
     */
    private String[] getUserType() {
        
        ADFContext  adfCtx = ADFContext.getCurrent();
        Object      _request = adfCtx.getEnvironment().getRequest();
        if (_request != null && _request instanceof HttpServletRequest) {                  
            HttpSession _session = null;
            _session = ((HttpServletRequest)_request).getSession(true);

            //users that have the adf.sample.pwrusr.POWER_USER session attribute set to
            //true run the document in power user modus
            Object isPowerUserSessionFlag =
                _session.getAttribute(USER_TYPE_PARAMETER);
            boolean isSessionPowerUser =
                isPowerUserSessionFlag == null ? isPowerUser :
                ((Boolean)isPowerUserSessionFlag) == true ?
                true : false;

            //set session flag only if its not available
            if (isPowerUserSessionFlag == null && isPowerUser) {
                _session.setAttribute(USER_TYPE_PARAMETER, isPowerUser);
            }

            //if power user, return customization layer value
            if (isSessionPowerUser) {
                return new String[] { PowerUserLayerName };
            }
        }
        //if normal user, return empty value so that no validation is applied
        return new String[0];
    }
}
