package adf.sample.model.beans;


import adf.sample.pwusr.cc.PowerUserCC;

import java.io.IOException;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

import oracle.adf.controller.ControllerContext;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.view.rich.change.ChangeManager;
import oracle.adf.view.rich.component.rich.data.RichTable;
import oracle.adf.view.rich.component.rich.data.RichTree;
import oracle.adf.view.rich.context.AdfFacesContext;
import oracle.adf.view.rich.datatransfer.DataFlavor;
import oracle.adf.view.rich.datatransfer.Transferable;
import oracle.adf.view.rich.dnd.DnDAction;
import oracle.adf.view.rich.event.DropEvent;
import oracle.adf.view.rich.event.QueryEvent;
import oracle.adf.view.rich.model.FilterableQueryDescriptor;

import oracle.binding.BindingContainer;

import org.apache.myfaces.trinidad.change.AttributeComponentChange;
import org.apache.myfaces.trinidad.change.ReorderChildrenComponentChange;
import org.apache.myfaces.trinidad.event.ReturnEvent;
import org.apache.myfaces.trinidad.model.RowKeySet;


public class AllEmployeesBacking {
    private RichTree locTreeInstance;
    private RichTable employeeTableInstance;

    public AllEmployeesBacking() {
    }

    public void onDialogReturn(ReturnEvent returnEvent) {
        String rowKey = (String)returnEvent.getReturnValue();

        if (rowKey != null) {
            BindingContext bindingContext = BindingContext.getCurrent();
            BindingContainer bindings =
                bindingContext.getCurrentBindingsEntry();
            DCIteratorBinding iter =
                (DCIteratorBinding)bindings.get("employeesInDepartmentIterator");
            iter.setCurrentRowWithKey(rowKey);
        }
    }

    public void onNormalUserChoice(ActionEvent actionEvent) {
        //user is not a power user
        setSessionAttribute(PowerUserCC.USER_TYPE_PARAMETER, false);
        //apply MDS changes
        redirectToSelf();
    }

    public void onPowerUserChoice(ActionEvent actionEvent) {
        //user is power user
        setSessionAttribute(PowerUserCC.USER_TYPE_PARAMETER, true);
        //apply MDS changes
        redirectToSelf();
    }


    /**
     * Redirect the page to itself so MDS changes can be applie based on the
     * user selection. Note that this method assumes that the user/ poweruser
     * selection is performed in a jspx document in an unbounded task flow
     */
    private void redirectToSelf() {
        FacesContext fctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = fctx.getExternalContext();
        String viewId = fctx.getViewRoot().getViewId();
        ControllerContext controllerCtx = ControllerContext.getInstance();
        String activityURL = controllerCtx.getGlobalViewActivityURL(viewId);

        try {
            ectx.redirect(activityURL);
            FacesContext.getCurrentInstance().responseComplete();
        } catch (IOException e) {
            //Can't redirect
            e.printStackTrace();
            fctx.renderResponse();
        }
    }

    /**
     * Helper method to write attributes into the session
     * @param attr  name of the session attribute (String)
     * @param value attribute value (Object)
     */
    private void setSessionAttribute(String attr, Object value) {
        FacesContext fctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = fctx.getExternalContext();
        Map sessionMap = ectx.getSessionMap();

        sessionMap.put(attr, value);
    }

    /**
     * returns true if used session is configured to be power user. Otherwise
     * false is returned
     */
    public boolean isPowerUser() {
        FacesContext fctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = fctx.getExternalContext();
        Map sessionMap = ectx.getSessionMap();
        Object param = sessionMap.get(PowerUserCC.USER_TYPE_PARAMETER);
        boolean isPowerUser = false;
        isPowerUser = param == null ? false : (Boolean)param;
        return isPowerUser;
    }

    public void onToggleColumnOrdering(ActionEvent event){
        RichTable table = getEmployeeTableInstance();
        boolean reorderingDisabledVal = (Boolean)table.getAttributes().get("disableColumnReordering");
        //toggle component attribute value
        table.getAttributes().put("disableColumnReordering", !reorderingDisabledVal);
        //persist the change for the duration of the user session or beyond using MDS
        this.persistAttributeChange("disableColumnReordering", table, !reorderingDisabledVal);
    }


    public void setEmployeeTableInstance(RichTable employeeTableInstance) {
        this.employeeTableInstance = employeeTableInstance;
    }

    public RichTable getEmployeeTableInstance() {
        return employeeTableInstance;
    }

    /**
     * method that filters "NULL" as a table filter to set the value to null. This allows
     * to query all in a table filter that is controlled by a single select list
     * @param queryEvent
     */
    public void onQueryTable(QueryEvent queryEvent) {
        FilterableQueryDescriptor descriptor = null;
        descriptor = (FilterableQueryDescriptor)queryEvent.getDescriptor();
        Map filterCriteriaMap = descriptor.getFilterCriteria();

        //get the filter entry for the DepartmentId.
        Object departmentId = filterCriteriaMap.get("DepartmentId");
        Object managerId = filterCriteriaMap.get("ManagerId");
        Object locationId = filterCriteriaMap.get("LocationId");

        /*
         * Note: In this example, all selectOneChoice lists filter the query
         * by oracle.jbo.Number. If a String is detected then this means the
         * user selected "All" from the list of values to unset the filter
         */

        //value is "NULL" if all values should be queried
        if(departmentId instanceof String){
          filterCriteriaMap.remove("DepartmentId");
        }

        //value is "NULL" if all values should be queried
        if(managerId instanceof String){
         filterCriteriaMap.remove("ManagerId");
        }

        //value is "NULL" if all values should be queried
        if(locationId instanceof String){
            filterCriteriaMap.remove("LocationId");
        }

            invokeMethodBinding("#{bindings.allDepartmentsQuery.processQuery}",
                                new Object[] { queryEvent },
                                new Class[] { QueryEvent.class });
    }

    /**
     * overloaded convenience method for a single event
     */
    public Object invokeMethodBinding(String methodExpression, Object event,
                                      Class eventClass) {

        return invokeMethodBinding(methodExpression, new Object[] { event },
                                   new Class[] { eventClass });
    }

    /**
     * Method that creates and executes a MethodExpression for the provided EL
     * string
     * @param methodExpression java.lang.String that represents a valid EL string
     * @param parameters An array of Objects or null that provides the arguments
     * for the executed method
     * @param expectedParamTypes An array of <ClassType>.class or empty array describing
     * the types of the expected parameters
     * @return Object returned by the invoked method
     */
    public Object invokeMethodBinding(String methodExpression,
                                      Object[] parameters,
                                      Class[] expectedParamTypes) {
        FacesContext fctx = FacesContext.getCurrentInstance();
        ELContext elctx = fctx.getELContext();
        Application application = fctx.getApplication();
        ExpressionFactory exprFactory = application.getExpressionFactory();
        MethodExpression methodExpr =
            exprFactory.createMethodExpression(elctx, methodExpression,
                                               Object.class,
                                               expectedParamTypes);
        return methodExpr.invoke(elctx, parameters);
    }


    /*
     *  CHANGE PERSISTENCE
     */

    private void persistAttributeChange(String attribute, UIComponent component, Object value){
        AttributeComponentChange attributeChange = null;
        attributeChange = null;
        attributeChange = new AttributeComponentChange(attribute, value);

        FacesContext facesCtx = FacesContext.getCurrentInstance();
        AdfFacesContext adfFacesCtx = AdfFacesContext.getCurrentInstance();
        //ChangeManager should be of type org.apache.myfaces.trinidad.change.ChangeManager but
        //deprectated oracle.adf.view.rich.change.ChangeManager is returned. The one cannot be
        //casted to the other. Bug 9652352 is filed to address this API issue.
        ChangeManager manager = adfFacesCtx.getChangeManager();
        manager.addComponentChange(facesCtx, component, attributeChange);
    }

    /**
     * method called from the drop tag on the input components
     * @param dropEvent
     * @return move/none
     */
    public DnDAction handleInputTextMove(DropEvent dropEvent) {
            FacesContext fctx = FacesContext.getCurrentInstance();
            //access the payload of the drag and drop operation
            Transferable transferable = dropEvent.getTransferable();
            //get the UI component that is moved in the layout container
            UIComponent dragComponent =
                transferable.getData(DataFlavor.UICOMPONENT_FLAVOR);
            //get the component that received the drop. The dragged component
            //will be placed right below this component
            UIComponent dropComponent = dropEvent.getDropComponent();
            //the parent layout component af:panelFormLayout
            UIComponent dropParent = dropComponent.getParent();
            if (dragComponent != null &&
                dragComponent != dropComponent) {
                //get the number of input components in the panelFormLayout
                int childCount = dropParent.getChildCount();
                //create a list to hold the component Ids in the new order
                List<String> newComponentList =
                    new ArrayList<String>(childCount);
                List<UIComponent> inputfields = dropParent.getChildren();
                //iterate over all panelFormLayout children and compare the
                //child with the drag and the drop component to create the
                //new component order
                for (UIComponent currComponent : inputfields) {
                    String currComponentId = currComponent.getId();
                    if (!currComponentId.equals(dragComponent.getId())) {
                        newComponentList.add(currComponentId);
                        if (currComponentId.equals(dropComponent.getId())) {
                            newComponentList.add(dragComponent.getId());
                        }
                    }
                }
                //Persist the changed component order
                ReorderChildrenComponentChange reorderedChildChange =
                    new ReorderChildrenComponentChange(newComponentList);
                reorderedChildChange.changeComponent(dropParent);

                AdfFacesContext adfFacesCtx = AdfFacesContext.getCurrentInstance();
                ChangeManager cm =  adfFacesCtx.getChangeManager();
                cm.addComponentChange(fctx, dropParent, reorderedChildChange);

                adfFacesCtx.addPartialTarget(dropParent);
                return DnDAction.MOVE;
            }
          return DnDAction.NONE;
        }
}
