package adf.sample.view.extension;

import java.util.Map;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

import oracle.adf.model.binding.DCBindingContainer;

import oracle.adf.view.rich.context.AdfFacesContext;

import oracle.binding.BindingContainer;
import oracle.binding.BindingContainerValidator;
/**
 * Custom ADF binding container validator class to skip validation based on session context 
 * information
 */
public class AdfBindingValidator implements BindingContainerValidator {
    /*
     * Reads validation flag from pageFlowScope. If flag exists then it is 
     * evaluated, if flag is missing, validation is always performed
     */
    public static final String ENABLE_DC_VALIDATION = "validate.on.binding.key";
    
    public AdfBindingValidator() {
        super();
    }

    public void validateBindingContainer(BindingContainer bindingContainer) {
        
        FacesContext fctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = fctx.getExternalContext();
        
        AdfFacesContext adfFacesContext = AdfFacesContext.getCurrentInstance();
        Map<String, Object> flowScope = adfFacesContext.getPageFlowScope();
        Object dataControlValidation = flowScope.get(ENABLE_DC_VALIDATION);
        //skip validation if flag is set to false
       
        if ((dataControlValidation != null) &&  
            ((String) dataControlValidation).equalsIgnoreCase("FALSE")){
            //avoid validation
            ((DCBindingContainer)bindingContainer).setSkipValidation(true);
        }
        //validate
        else{
            return;
        }
    }
}
