package adf.sample.view;

import java.util.HashMap;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

import oracle.adf.controller.ControllerContext;
import oracle.adf.controller.TaskFlowId;
import oracle.adf.model.BindingContext;

import oracle.binding.BindingContainer;

import oracle.jbo.uicli.binding.JUCtrlHierBinding;

import org.apache.myfaces.trinidad.render.ExtendedRenderKitService;
import org.apache.myfaces.trinidad.util.Service;


public class BrowseDepartmentsBacking {
    
    private final String taskflowId="edit-task-flow-definition";
    private final String taskflowDocument="/WEB-INF/edit-task-flow-definition.xml";
    
    public BrowseDepartmentsBacking() {
        super();
    }

    /*
     * method called by the command menu item on the context menu. The action event
     */
    public void onLaunchForEdit(ActionEvent actionEvent) {        
        //access the ADF binding layer and access the tree binding that populates the table
        BindingContext bctx = BindingContext.getCurrent();
        BindingContainer bindings = bctx.getCurrentBindingsEntry();       
        JUCtrlHierBinding model = (JUCtrlHierBinding) bindings.get("DepartmentsView1");
        //get the current selected row key from the iterator binding referenced from the
        //table binding (tree binding)
        String rwKeyString = model.getDCIteratorBinding().getCurrentRowKeyString();
        launchWindow(rwKeyString);
    }
    
    private void launchWindow(String rwKey) {
        FacesContext fctx = FacesContext.getCurrentInstance();
        String rowKeyString = rwKey;
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("rowKey",rowKeyString);
        String taskflowURL = ControllerContext.getInstance().getTaskFlowURL(false,new TaskFlowId(taskflowDocument,taskflowId),params);
        ExtendedRenderKitService erks = Service.getRenderKitService(fctx, ExtendedRenderKitService.class);
        StringBuilder script = new StringBuilder();
        script.append("window.open(\""+taskflowURL+"\");");
        erks.addScript(FacesContext.getCurrentInstance(), script.toString());                      
    }
    
}
