package adf.sample;

import javax.faces.event.ActionEvent;

import org.apache.myfaces.trinidad.model.BoundedRangeModel;
 
 
/**The progress bar model in this example allows components to use style classes
* .green, .yellow, .red in combination with skinning to color the progress bar 
* according to its value state. 
* 
* This bean must be in a scope larger tha request to keep the state across 
* requests. The scope in this sample is set to viewScope, which means that 
* this progress bar stops when the user navigates off the page. 
*/
public class ProgressBarModel extends BoundedRangeModel {
  
  //progress bar status
  final String GREEN  = "green";
  final String YELLOW = "yellow";
  final String RED    = "red";
   
  //first style class color is red as progress has just started
  String styleClass = RED;
  Thread newProgress = null;
  boolean stopFlag = false;
  
  long maximum = 10;
  long value = 0;
  
  long greenBoundary = maximum *  4/5;
  long yellowBoundary = maximum * 3/5;
      
    public ProgressBarModel() {
        super();
    }

    public long getMaximum() {
        return maximum;
    }

    public long getValue() {
        return value;
    }

    public void setMaximum(long maximum) {
        this.maximum = maximum;
    }

    public void setValue(long value) {
        this.value = value;
    }
    
    //start progress count
    public void start (ActionEvent ae){
      value = 0;
      stopFlag = false;
      styleClass = RED;
      //make sure thread is properly cleared before starting a new
      //thread
      if (newProgress!=null){
        newProgress.interrupt();
      }
      
      ProgressUpdater progressSimulator = new ProgressUpdater();
      newProgress = new Thread(progressSimulator);
      newProgress.start();

    }
    
  public void stop (ActionEvent ae){
    value = 0;
    styleClass = RED;
    stopFlag = true;
  }
    
  //Simulate a business service progress
  class ProgressUpdater implements Runnable
  { 
      
  
      public void run(){
       try
        {
           //stop fag is true if it is set to true or if value is equals or greater
           //than maximum
           stopFlag = stopFlag == true? true : (value < maximum? false:true);
           
          //run in loop until stop condition is met. Make sure system doesn't
           //fail if values are initially set to the same value
          while (!stopFlag && value != maximum) {
                  Thread.sleep(1000);
                  value = value +1;
              //set the color boundaries
              if (value >= greenBoundary){
               styleClass = GREEN;
              }
              else if(value >= yellowBoundary){
               styleClass = YELLOW;
              }
              else{
               styleClass = RED;
              }
              
              if (value == maximum){
                stopFlag = true;
              }
           }
           //stop thread
            newProgress.interrupt();
            newProgress = null;              
        }
        catch (Exception exc)
        {
            exc.printStackTrace();
        }
      }
    };

    /**
     * method to be referenced from the StyleClass property of the progress bar
     * component. The return string in combination with the skin definition sets
     * the color of the progress bar item
     * @return
     */
    public String getStyleClass() {
        return styleClass;
    }
}
