package adf.sample;

import javax.el.ELContext;

import javax.el.ExpressionFactory;

import javax.el.MethodExpression;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

import oracle.adf.view.rich.component.rich.RichPoll;
import oracle.adf.view.rich.component.rich.layout.RichPanelGroupLayout;
import oracle.adf.view.rich.context.AdfFacesContext;

public class ProgressBarSampleBean {
    private RichPoll pollComponent;
    private RichPanelGroupLayout pollComponentParent;

    public ProgressBarSampleBean() {
        super();
    }

    public void setPollComponent(RichPoll pollComponent) {
        this.pollComponent = pollComponent;
    }

    public RichPoll getPollComponent() {
        return pollComponent;
    }

      public void setPollComponentParent(RichPanelGroupLayout pollComponentParent) {
        this.pollComponentParent = pollComponentParent;        
    }

    public RichPanelGroupLayout getPollComponentParent() {
        return pollComponentParent;
    }
    
    
    /*
     * Start and stop Polling
     */
    
    //method called to start af:pollComponent
      public void onProgressBarStart(ActionEvent actionEvent) {
        pollComponent.setRendered(true);
        this.executeMethodExpression("#{viewScope.ProgressBarModel.start}", actionEvent);
        AdfFacesContext.getCurrentInstance().addPartialTarget(pollComponentParent);
      }

  //method called to stop af:pollComponent
    public void onProgressBarStop(ActionEvent actionEvent) {
      pollComponent.setRendered(false);
      this.executeMethodExpression("#{viewScope.ProgressBarModel.stop}", actionEvent);
      AdfFacesContext.getCurrentInstance().addPartialTarget(pollComponentParent);
    }
      
      /**
     * helper method to invoke start/stop on the progressbar model
     * @param expression
     * @param actionEvent
     */
      public void executeMethodExpression(String expression, ActionEvent actionEvent){
         FacesContext fctx = FacesContext.getCurrentInstance();
         Application application = fctx.getApplication();
         
         ELContext elctx = fctx.getELContext();
         ExpressionFactory elFactory = application.getExpressionFactory();
         MethodExpression me = elFactory.createMethodExpression(elctx, expression, 
                                                                null, 
                                                                new Class[]{ActionEvent.class});
         me.invoke(elctx,new Object[]{actionEvent});
      }
}
