package adf.sample.bean;

import java.util.ArrayList;

import javax.faces.event.ValueChangeEvent;

import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCIteratorBinding;

import oracle.binding.BindingContainer;

import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.domain.Number;
import oracle.jbo.uicli.binding.JUCtrlListBinding;


public class RelocateEmployee {
    
    private Integer[] selectedIndxs;
    private ArrayList<Integer> selectedIndxList;

    public RelocateEmployee() {
    }

    public void setSelectedIndxs(Integer[] selectedIndxs) {
        this.selectedIndxs = selectedIndxs;
    }

    //method referenced from the value property of the Select Many Shuttle
    //component. Note that a related setter method is contained in this managed
    //bean as well
    public Integer[] getSelectedIndxs() {
      selectedIndxs = null;
      selectedIndxList = new ArrayList<Integer>();
      
      BindingContext bctx = BindingContext.getCurrent();
      BindingContainer bindings = bctx.getCurrentBindingsEntry();
      //get all employees for the current selected department
      DCIteratorBinding employeesInDepartmentDciter = (DCIteratorBinding)bindings.get("employeeInDepartmentIterator");          
      RowSetIterator rsi = employeesInDepartmentDciter.getRowSetIterator();
      //get access to the "allEmployees" list binding
      JUCtrlListBinding allEmployeesList  = (JUCtrlListBinding)bindings.get("allEmployees");
      DCIteratorBinding allEmployeesIter = allEmployeesList.getDCIteratorBinding();
      
      while(rsi.hasNext()){
         //iterate over the employees in the selected department and find the 
         //employee record index in the allEmployees iterator. Note that the
        //employee in the allEmployees iterator has a different index number 
        //than the same employee record in the department's dependent View Object 
         Row rw = (Row) rsi.next();
         allEmployeesIter.setCurrentRowWithKey(rw.getKey().toStringFormat(true));
         int indx = allEmployeesIter.getCurrentRowIndexInRange();
         selectedIndxList.add(indx);
      }
      
      selectedIndxs = selectedIndxList.toArray(new Integer[selectedIndxList.size()]);
        return selectedIndxs;
    }

    //to-do in this method: get the DepartmentsId and update the 
    //employees added to the department
    public void onEmployeesChange(ValueChangeEvent valueChangeEvent) {
        //get all items left as selected after a change
        Integer[] employeesInDepartment = (Integer[]) valueChangeEvent.getNewValue();
       //get the DepartmentId 
        BindingContext bctx = BindingContext.getCurrent();
        BindingContainer bindings = bctx.getCurrentBindingsEntry();
        DCIteratorBinding allDepartmentsIterator = (DCIteratorBinding)bindings.get("allDepartmentsIterator");   
        //get current row
        Row currentRow = allDepartmentsIterator.getCurrentRow();
        Number departmentId = (Number) currentRow.getAttribute("DepartmentId");
        
        //compare the selected values in the list and update all rows that don't 
        //yet have the department Id of the selected department
        
        JUCtrlListBinding allEmployeesList  = (JUCtrlListBinding)bindings.get("allEmployees");
        DCIteratorBinding allEmployeesIter = allEmployeesList.getDCIteratorBinding();

        if (employeesInDepartment.length > 0) {
            for(int index : employeesInDepartment){
              Row rowToUpdate = allEmployeesIter.getRowAtRangeIndex(index);
                if (!((Number)rowToUpdate.getAttribute("DepartmentId")).equals(departmentId)){
                 rowToUpdate.setAttribute("DepartmentId", departmentId);
                }
            }
            //Note that this sample does not commit the changes. I do this on 
            //purpose not to mess with your database.
        }
    }
    public String onSubmitRelocation() {
        return null;
    }
}
