package adf.sample.view.bean;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;

import oracle.adf.view.rich.component.rich.RichPopup;
import oracle.adf.view.rich.component.rich.data.RichTable;
import oracle.adf.view.rich.context.AdfFacesContext;
import oracle.adf.view.rich.event.QueryEvent;

public class FindPanelBean {
    private RichTable employeesTable;
    private RichPopup findPopup;

    public FindPanelBean() {
    }

    /*
  * method called from the af;query component's query listener
  */

    public void onQuery(QueryEvent queryEvent) {
        //preserve default query behvior
        String mexpr = "#{bindings.ImplicitViewCriteriaQuery.processQuery}";
        processMethodExpression(mexpr, queryEvent, QueryEvent.class);
        //close dialog
        findPopup.hide();
        AdfFacesContext adfFacesContext = AdfFacesContext.getCurrentInstance();
        adfFacesContext.addPartialTarget(employeesTable);
    }


    /*
  * simplified method for invoking an EL for a single argument and argument
  * class
  */

    public Object processMethodExpression(String methodExpression,
                                          Object event, Class eventClass) {
        return processMethodExpression(methodExpression,
                                       new Object[] { event },
                                       new Class[] { eventClass });
    }

    /*
   * method that executes a method expression
   */

    private Object processMethodExpression(String methodExpression,
                                           Object[] parameters,
                                           Class[] expectedParamTypes) {
        FacesContext fctx = FacesContext.getCurrentInstance();
        ELContext elctx = fctx.getELContext();
        Application app = fctx.getApplication();
        ExpressionFactory exprFactory = app.getExpressionFactory();
        MethodExpression methodExpr =
            exprFactory.createMethodExpression(elctx, methodExpression,
                                               Object.class,
                                               expectedParamTypes);
        return methodExpr.invoke(elctx, parameters);
    }

  /*
   * ***************************
   * JSF Component Bindings
   * ***************************
   */
    public void setEmployeesTable(RichTable employeesTable) {
        this.employeesTable = employeesTable;
    }

    public RichTable getEmployeesTable() {
        return employeesTable;
    }

    public void setFindPopup(RichPopup findPopup) {
        this.findPopup = findPopup;
    }

    public RichPopup getFindPopup() {
        return findPopup;
    }
}
