package adf.sample.view;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;

import oracle.adf.model.BindingContext;

import oracle.binding.BindingContainer;

import oracle.jbo.uicli.binding.JUEventBinding;

import org.apache.myfaces.trinidad.event.SelectionEvent;
import org.apache.myfaces.trinidad.event.SelectionListener;


public class DepartmentsBean {
    public DepartmentsBean() {
    }
    
    public void onQueryDepartments(SelectionEvent selectionEvent) {
        //preserve default Selection Event behavior
        String mexpr = "#{bindings.allDepartments.collectionModel.makeCurrent}";
        processMethodExpression(mexpr, selectionEvent, SelectionEvent.class);
        
        //invoke the ContextualEvent. Access the binding layer through 
        //the BindingContext
        BindingContext bctx = BindingContext.getCurrent();
        BindingContainer bindings = bctx.getCurrentBindingsEntry();
        //access the eventBinding that is mapped as the event producer
        JUEventBinding tableSelectionEvent = (JUEventBinding) bindings.get("TableSelectionEvent");
        //get the selection listener defoned on the event binding
        SelectionListener eventBindingListener = (SelectionListener) tableSelectionEvent.getListener();
        //invoke the event producer
        eventBindingListener.processSelection(selectionEvent);
    }
    
  /*
  * simplified method for invoking an EL for a single argument and argument
  * class
  */

   public Object processMethodExpression(String methodExpression,
                                         Object event, Class eventClass) {
       return processMethodExpression(methodExpression,
                                      new Object[] { event },
                                      new Class[] { eventClass });
   }

   /*
  * method that executes a method expression
  */

   private Object processMethodExpression(String methodExpression,
                                          Object[] parameters,
                                          Class[] expectedParamTypes) {
       FacesContext fctx = FacesContext.getCurrentInstance();
       ELContext elctx = fctx.getELContext();
       Application app = fctx.getApplication();
       ExpressionFactory exprFactory = app.getExpressionFactory();
       MethodExpression methodExpr =
           exprFactory.createMethodExpression(elctx, methodExpression,
                                              Object.class,
                                              expectedParamTypes);
       return methodExpr.invoke(elctx, parameters);
   }
}
