package adf.sample.view.datacontrol;


import adf.sample.view.ShowEmployeesBean;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;

import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.view.rich.component.rich.data.RichTable;
import oracle.adf.view.rich.context.AdfFacesContext;

import oracle.binding.OperationBinding;

import oracle.jbo.uicli.binding.JUCtrlHierBinding;

import org.apache.myfaces.trinidad.model.CollectionModel;


public class ContextualEventHandler {
    public ContextualEventHandler() {
        super();
    }
    
    public void updateTableForDepartmentId(String departmentIdPayLoad){

       FacesContext fctx = FacesContext.getCurrentInstance();
       Application app = fctx.getApplication();
       ELContext elctx = fctx.getELContext();
       ExpressionFactory expressionFactory = app.getExpressionFactory();
       
       //access the managed bean defined in the bounded task flow for the
       //employees table
       ValueExpression showEmployeeBeanAccess = 
                expressionFactory.createValueExpression(elctx, "#{backingBeanScope.showEmployeesBean}", Object.class);
       
       //cast it to the bean instance
       ShowEmployeesBean employeesBean = (ShowEmployeesBean) showEmployeeBeanAccess.getValue(elctx);
       
       //get access to the table component
       RichTable table = employeesBean.getEmployeestable();
       //get access to the binding layer used by the table
       
       CollectionModel model = (CollectionModel) table.getValue();
       //access the tree binding used by the table
       JUCtrlHierBinding employeesTableBinding = (JUCtrlHierBinding) model.getWrappedData();
       //access the binding container
       DCBindingContainer dcbindings = employeesTableBinding.getBindingContainer();
       //access the EcecuteWithParams method exposed in the binding layer to re-query
       //the table data based on the contextual event payLoad

       OperationBinding operationBinding = dcbindings.getOperationBinding("ExecuteWithParams");      
       operationBinding.getParamsMap().put("departmentIdVar", departmentIdPayLoad);
       operationBinding.execute();
      
       //refresh the table without re-loading the bounded task flow
       AdfFacesContext.getCurrentInstance().addPartialTarget(table);
    }
}
