package oracle.adf.sample.ws;


import java.util.Collections;
import java.util.Set;

import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class CustomWebServiceHandler implements SOAPHandler<SOAPMessageContext> {


    public CustomWebServiceHandler() {
        super();
    }

    public Set getHeaders() {
        return Collections.emptySet();
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        Boolean outbound =
            (Boolean)messageContext.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);
        if (outbound) {
            System.out.println("SOAP message departing...");
        } else {
            System.out.println("SOAP message incoming...");
            SOAPMessage sOAPMessage = messageContext.getMessage();
            try {
                SOAPEnvelope envelope = sOAPMessage.getSOAPPart().getEnvelope();
                String authenticatedUser = envelope.getHeader().getAttribute("authenticatedUser");
                if(authenticatedUser != null && authenticatedUser.length() > 0){
                  System.out.println("The authenticated user in the incoming message is: "+authenticatedUser);
                }
            } catch (SOAPException e) {
                //for now just print exception
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return false;
    }

    public void close(MessageContext context) {
    }
}
