package oracle.pojo.facade;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.jws.HandlerChain;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebService;

import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;

import oracle.pojo.entities.Departments;
import oracle.pojo.entities.Employees;
import oracle.pojo.entities.Locations;
import oracle.pojo.entities.VacationRequest;
import oracle.pojo.factory.DepartmentsList;
import oracle.pojo.factory.EmployeesList;
import oracle.pojo.factory.LocationsList;
import oracle.pojo.factory.VacationRequestList;

/**
 * Pagination example for POJO. Departments and Employees data is provided
 * in range defined by the RangeSize property on the iterator in the PageDef
 * file. The DataControls.dcx file must be configured as shown below
 *
 *  <bean-definition BeanClass="oracle.pojo.facade.SessionFacade"
 *     DataControlHandler="oracle.adf.model.adapter.bean.DataFilterHandler"
 *     xmlns="http://xmlns.oracle.com/adfm/adapter/bean"/>
 *
 * @Frank Nimphius
 */
@WebService(name = "SaessionFacade", serviceName = "SamplePojoWebService", portName = "SaessionFacadePort")
@HandlerChain(file = "SamplePojoWebService-HandlerChain.xml")
public class SessionFacade implements Serializable{
    
    //order is important
    private EmployeesList       employees   = new EmployeesList();
    private DepartmentsList     departments = new DepartmentsList(employees);
    private LocationsList       locations   = new LocationsList(departments);
    private VacationRequestList requests  = new VacationRequestList();
  
    
    public SessionFacade() {
    }

    @WebMethod
    public List<Locations> getAllLocations(){
        return locations.getLocationsList();
    }

    @WebMethod
    public List<VacationRequest> getAllVacationRequests(){
       return requests.getVacationRequestList();
    }

/*
 * QUERY Departments and handle pagination
 */

    @WebMethod
    public List<Departments> getAllDepartments(){
       return departments.getDepartmentsList();
    }

    //method called by the ADF binding layer to perform paging

    @WebMethod(exclude = true)
    public List<Departments> getAllDepartments(int index, int range){
        System.out.println("Pagination Departments ! from "+index+" for length "+range);
        
        ArrayList<Departments> rangeList = new ArrayList<Departments>();
        
        for (int i = index; i < departments.getDepartmentsList().size() && i < index + range;  i++) {   
            rangeList.add(departments.getDepartmentsList().get(i));
        }

        return rangeList;
    }
    
    //method required by the ADF binding layer to perform paging

    @WebMethod(exclude = true)
    public long getAllDepartmentsSize(){
        return departments.getDepartmentsList().size();
    }


    /*
     * QUERY Employees and handle pagination
     */

    @RequestWrapper(className = "jaxws.overloaded.GetAllEmployees2")
    @ResponseWrapper(className = "jaxws.overloaded.GetAllEmployees2_Response")
    @WebMethod(operationName = "getAllEmployees_2")
    public List<Employees> getAllEmployees(){
           return employees.getEmployeesList();
        }

        //method called by the ADF binding layer to perform paging

    @WebMethod(exclude = true)
    public List<Employees> getAllEmployees(int index, int range){
            
            System.out.println("Pagination Employees ! from "+index+" for length "+range);            
            
            ArrayList<Employees> rangeList = new ArrayList<Employees>();            
            for (int i = index;  i < employees.getEmployeesList().size() && i < index + range;  i++) {   
                rangeList.add(employees.getEmployeesList().get(i));
            }
            return rangeList;
        }
        
        //method required by the ADF binding layer to perform paging

    @WebMethod(exclude = true)
    public long getAllEmployeesSize(){
            return employees.getEmployeesList().size();
        }

    @Oneway
    @WebMethod
    public void createNewEmployee(Employees employee){
          employees.addEmployee(employee);
        }

    @WebMethod
    public List<Employees> findEmployee (Employees employee){
          return employees.findEmployee(employee);
        }


    @WebMethod
    public List<Departments> getDepartmentsLookUp(){
        return departments.getDepartmentsList();
    }

    @WebMethod
    public ArrayList<Employees> findEmployeeById(Long employeeId){
            return employees.getEmployeeById(employeeId);
    }

    @WebMethod
    public List<Employees> findEmployeesByLastName(String _lastname){
        
        ArrayList<Employees> _list = (ArrayList<Employees>) employees.getEmployeesList();
                       
        boolean useWildCard = false;
        String srchString = null;

        useWildCard = _lastname.endsWith("%")?true:false;
        if (useWildCard){
            srchString = _lastname.substring(0,_lastname.length()-1);
        }
        else{
            srchString = _lastname;
        }

        ArrayList<Employees> returnList = new ArrayList<Employees>();

            for (Employees employee : _list) {
                        if(useWildCard){
                            if (employee.getLastname().toLowerCase().indexOf(srchString.toLowerCase(),0)>-1)  {
                               returnList.add(employee);
                            }
                        }
                        else{
                            if (employee.getLastname().equalsIgnoreCase(srchString))  {
                                returnList.add(employee);
                       }
                }
        }
        return returnList;
    }

    @WebMethod
    public List<Employees> findAllEmployeesByDepartmentId(Long departmentId){
            return employees.getEmployeesByDepartmentId(departmentId);
    }


    @Oneway
    @WebMethod
    public void mergeEmployee(Employees emp){
        this.doCommit(emp);
    }

    @Oneway
    @WebMethod
    public void mergeDepartment(Departments dept){
        this.doCommit(dept);
    }

    @Oneway
    @WebMethod
    public void mergeLocations(Locations loc){
        this.doCommit(loc);
    }

    @Oneway
    @WebMethod
    public void doCommit (Object o){
        
        if (o instanceof Departments){
            departments.updateDepartment((Departments) o);
            return;
        }
        else if (o instanceof Employees){            
            employees.updateEmployee((Employees) o);
            return;
        }
        else if (o instanceof Locations){            
            locations.updateLocations((Locations)o);
            return;
        }
    }
}
