/*
 * Decompiled with CFR 0.152.
 */
package adf.sample.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import netscape.javascript.JSObject;

public class MessageApplet
extends JApplet {
    private static final long serialVersionUID = 1L;
    private JPanel messagePanel = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JTextArea messageField = new JTextArea();
    private JButton sendMessageButton = new JButton();
    private FlowLayout flowLayout1 = new FlowLayout();
    private JPanel commandPanel = new JPanel();
    private JCheckBox printToServer = new JCheckBox();

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.setSize(new Dimension(400, 112));
        this.setBackground(new Color(214, 214, 214));
        this.messagePanel.setLayout(this.flowLayout1);
        this.messagePanel.setMinimumSize(new Dimension(400, 120));
        this.messagePanel.setPreferredSize(new Dimension(400, 120));
        this.messagePanel.setBackground(new Color(231, 231, 231));
        this.messagePanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.messagePanel.setSize(new Dimension(400, 120));
        this.messageField.setColumns(30);
        this.messageField.setRows(4);
        this.messageField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MessageApplet.this.onMessageTextFocus(e);
            }
        });
        this.sendMessageButton.setText("Send Message");
        this.sendMessageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageApplet.this.sendMessageButton_actionPerformed(e);
            }
        });
        this.sendMessageButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                MessageApplet.this.sendMessageButton_keyPressed(e);
            }
        });
        this.commandPanel.setBackground(new Color(231, 231, 231));
        this.printToServer.setText("Print to Server");
        this.printToServer.setBackground(new Color(231, 231, 231));
        this.printToServer.setActionCommand("printToServer");
        this.messagePanel.add((Component)this.messageField, "messageField");
        this.commandPanel.add((Component)this.printToServer, "checkBox");
        this.commandPanel.add((Component)this.sendMessageButton, "sendMessageButton");
        this.messagePanel.add((Component)this.commandPanel, null);
        this.getContentPane().add((Component)this.messagePanel, "Center");
    }

    @Override
    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        MessageApplet applet = new MessageApplet();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)applet, "Center");
        frame.setTitle("Applet Frame");
        applet.init();
        applet.start();
        frame.setSize(300, 300);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        frame.setLocation((d.width - frameSize.width) / 2, (d.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    private void sendMessageButton_actionPerformed(ActionEvent e) {
        String message = this.messageField.getText();
        JSObject win = JSObject.getWindow((Applet)this);
        if (this.printToServer.isSelected()) {
            win.eval("callAdfFromJavaMessage('" + message + "',true);");
        } else {
            win.eval("callAdfFromJavaMessage('" + message + "',false);");
        }
    }

    public void handleJavaScriptToAppletMessage(String message) {
        this.messageField.setBackground(Color.yellow);
        this.messageField.setText(message);
    }

    public void setFocusOnTextField() {
        this.messageField.requestFocus();
    }

    private void onMessageTextFocus(FocusEvent e) {
        this.messageField.setBackground(Color.white);
        this.messageField.setText(null);
    }

    private void sendMessageButton_keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 10) {
            String message = this.messageField.getText();
            JSObject win = JSObject.getWindow((Applet)this);
            if (this.printToServer.isSelected()) {
                win.eval("callAdfFromJavaMessage('" + message + "',true);");
            } else {
                win.eval("callAdfFromJavaMessage('" + message + "',false);");
            }
        }
    }
}

