package adf.sample.applet;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;

import netscape.javascript.JSObject;


public class MessageApplet extends JApplet {
    @SuppressWarnings("compatibility:-7038748619595093807")
    private static final long serialVersionUID = 1L;
    private JPanel messagePanel = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JTextArea messageField = new JTextArea();
    private JButton sendMessageButton = new JButton();
    private FlowLayout flowLayout1 = new FlowLayout();
    private JPanel commandPanel = new JPanel();
    private JCheckBox printToServer = new JCheckBox();

    public MessageApplet() {
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(borderLayout1);
        this.setSize(new Dimension(400, 112));
        this.setBackground(new Color(214, 214, 214));
        messagePanel.setLayout(flowLayout1);
        messagePanel.setMinimumSize(new Dimension(400, 120));
        messagePanel.setPreferredSize(new Dimension(400, 120));
        messagePanel.setBackground(new Color(231, 231, 231));
        messagePanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        messagePanel.setSize(new Dimension(400, 120));
        messageField.setColumns(30);
        messageField.setRows(4);
        messageField.addFocusListener(new FocusAdapter() {
                public void focusGained(FocusEvent e) {
                    onMessageTextFocus(e);
                }
            });
        sendMessageButton.setText("Send Message");
        sendMessageButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    sendMessageButton_actionPerformed(e);
                }
            });
        sendMessageButton.addKeyListener(new KeyAdapter() {
                public void keyPressed(KeyEvent e) {
                    sendMessageButton_keyPressed(e);
                }
            });
        commandPanel.setBackground(new Color(231, 231, 231));
        printToServer.setText("Print to Server");
        printToServer.setBackground(new Color(231, 231, 231));
        printToServer.setActionCommand("printToServer");
        messagePanel.add(messageField, "messageField");
        commandPanel.add(printToServer, "checkBox");
        commandPanel.add(sendMessageButton, "sendMessageButton");
        messagePanel.add(commandPanel, null);
        
        this.getContentPane().add(messagePanel, BorderLayout.CENTER);
    }

    public void init() {
        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        MessageApplet applet = new MessageApplet();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
        frame.getContentPane().add(applet, BorderLayout.CENTER);
        frame.setTitle( "Applet Frame" );
        applet.init();
        applet.start();
        frame.setSize(300, 300);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        frame.setLocation((d.width-frameSize.width)/2, (d.height-frameSize.height)/2);
        frame.setVisible(true);
    }
    static {
        try {
        } catch (Exception e) {
        }
    }

    private void sendMessageButton_actionPerformed(ActionEvent e) {
        
        String message = messageField.getText();
        JSObject win = (JSObject) JSObject.getWindow(this);
        //call the JavaScript message
        if(printToServer.isSelected()){
          //make sure message is printed to JSF managed bean
          win.eval("callAdfFromJavaMessage('"+message+"',true);");
        }
        else{
          win.eval("callAdfFromJavaMessage('"+message+"',false);");
        }

    }
    
    public void handleJavaScriptToAppletMessage(String message){    
      messageField.setBackground(Color.yellow);
      messageField.setText(message);
    }

    public void setFocusOnTextField(){
      messageField.requestFocus();
    }
    private void onMessageTextFocus(FocusEvent e) {
      messageField.setBackground(Color.white);
      messageField.setText(null);
    }

    private void sendMessageButton_keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 10){
          String message = messageField.getText();
          JSObject win = (JSObject) JSObject.getWindow(this);
          //call the JavaScript messae
          if(printToServer.isSelected()){
            //make sure message is printed to JSF managed bean
            win.eval("callAdfFromJavaMessage('"+message+"',true);");
          }
          else{
            win.eval("callAdfFromJavaMessage('"+message+"',false);");
          }
        }
    }
}
