package adf.sample.jpa;

import adf.sample.jpa.entities.Departments;
import adf.sample.jpa.entities.Employees;
import adf.sample.jpa.entities.Jobs;

import adf.sample.jpa.entities.Locations;

import java.util.List;

import javax.ejb.Local;
import javax.ejb.Stateless;

import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebService;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Stateless(name = "HumanResourcesSessionWs", mappedName = "HumanResourceService-HumanResourceService-HumanResourcesSessionWs")
@Local
@WebService(name = "HumanResourcesWs", serviceName = "HumanResourcesWs", portName = "HumanResourcesWsPort")
public class HumanResourcesSessionWsBean implements HumanResourcesSessionWsLocal {
    @PersistenceContext(unitName="hrapp")
    private EntityManager em;

    public HumanResourcesSessionWsBean() {
    }

    /** <code>select o from Jobs o</code> */
    @WebMethod
    public List<Jobs> getJobsFindAll() {
        return em.createNamedQuery("Jobs.findAll").getResultList();
    }

    @WebMethod
    public Departments persistDepartments(Departments departments) {
        em.persist(departments);
        return departments;
    }

    @WebMethod
    public Departments mergeDepartments(Departments departments) {
        return em.merge(departments);
    }

    @Oneway
    @WebMethod
    public void removeDepartments(Departments departments) {
        departments = em.find(Departments.class, departments.getDepartmentId());
        em.remove(departments);
    }

    /** <code>select o from Departments o</code> */
    @WebMethod
    public List<Departments> getDepartmentsFindAll() {
        return em.createNamedQuery("Departments.findAll").getResultList();
    }

    /** <code>select o from Departments o where o.departmentId = :deptId</code> */
    @WebMethod
    public List<Departments> getDepartmentsFindAllById(int deptId) {
        return em.createNamedQuery("Departments.findAllById").setParameter("deptId", deptId).getResultList();
    }

    /** <code>select o from Departments o where o.departmentName like :deptName</code> */
    @WebMethod
    public List<Departments> getDepartmentsFindAllByName(String deptName) {
        return em.createNamedQuery("Departments.findAllByName").setParameter("deptName", deptName+"%").getResultList();
    }

    @WebMethod
    public Employees persistEmployees(Employees employees) {
        em.persist(employees);
        return employees;
    }

    @WebMethod
    public Employees mergeEmployees(Employees employees) {
        return em.merge(employees);
    }

    @Oneway
    @WebMethod
    public void removeEmployees(Employees employees) {
        employees = em.find(Employees.class, employees.getEmployeeId());
        em.remove(employees);
    }

    /** <code>select o from Employees o</code> */
    @WebMethod
    public List<Employees> getEmployeesFindAll() {
        return em.createNamedQuery("Employees.findAll").getResultList();
    }

    /** <code>select o from Employees o where o.employeeId = :empId</code> */
    @WebMethod
    public List<Employees> getEmployeesFindAllByEmployeeId(int empId) {
        return em.createNamedQuery("Employees.findAllByEmployeeId").setParameter("empId", empId).getResultList();
    }

    /** <code>select o from Employees o where o.departmentId = :deptId</code> */
    @WebMethod
    public List<Employees> getEmployeesFindAllByDepartmentId(int deptId) {
        return em.createNamedQuery("Employees.findAllByDepartmentId").setParameter("deptId", deptId).getResultList();
    }

    @WebMethod(exclude = true)
    public Locations persistLocations(Locations locations) {
        em.persist(locations);
        return locations;
    }

    /** <code>select o from Locations o</code> */
    @WebMethod
    public List<Locations> getLocationsFindAll() {
        return em.createNamedQuery("Locations.findAll").getResultList();
    }
}
