package adf.sample.jpa;

import adf.sample.jpa.entities.Departments;
import adf.sample.jpa.entities.Employees;
import adf.sample.jpa.entities.Jobs;
import adf.sample.jpa.entities.Locations;

import java.util.List;

import javax.ejb.Local;

@Local
public interface HumanResourcesSessionWsLocal {
    List<Jobs> getJobsFindAll();

    Departments persistDepartments(Departments departments);

    Departments mergeDepartments(Departments departments);

    void removeDepartments(Departments departments);

    List<Departments> getDepartmentsFindAll();

    List<Departments> getDepartmentsFindAllById(int deptId);

    List<Departments> getDepartmentsFindAllByName(String deptName);

    Employees persistEmployees(Employees employees);

    Employees mergeEmployees(Employees employees);

    void removeEmployees(Employees employees);

    List<Employees> getEmployeesFindAll();

    List<Employees> getEmployeesFindAllByEmployeeId(int empId);

    List<Employees> getEmployeesFindAllByDepartmentId(int deptId);

    Locations persistLocations(Locations locations);

    List<Locations> getLocationsFindAll();
}
