package adf.sample.jpa.entities;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;

@Entity
@NamedQueries( { @NamedQuery(name = "Departments.findAll", query = "select o from Departments o"),
        @NamedQuery(name = "Departments.findAllById", query = "select o from Departments o where o.departmentId = :deptId"),
        @NamedQuery(name = "Departments.findAllByName", query = "select o from Departments o where o.departmentName LIKE :deptName") })
public class Departments implements Serializable {
    @Id
    @Column(name="DEPARTMENT_ID", nullable = false)
    private int departmentId;
    @Column(name="DEPARTMENT_NAME", nullable = false, length = 30)
    private String departmentName;
    @Column(name="LOCATION_ID")
    private int locationId;
    @Column(name="MANAGER_ID")
    private int managerId;

    public Departments() {
    }

    public Departments(int departmentId, String departmentName,
                       int locationId, int managerId) {
        this.departmentId = departmentId;
        this.departmentName = departmentName;
        this.locationId = locationId;
        this.managerId = managerId;
    }

    public int getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(int departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public int getLocationId() {
        return locationId;
    }

    public void setLocationId(int locationId) {
        this.locationId = locationId;
    }

    public int getManagerId() {
        return managerId;
    }

    public void setManagerId(int managerId) {
        this.managerId = managerId;
    }
}
