package adf.sample.jpa.entities;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;

@Entity
@NamedQueries({
  @NamedQuery(name = "Jobs.findAll", query = "select o from Jobs o")
})
public class Jobs implements Serializable {
    @Id
    @Column(name="JOB_ID", nullable = false, length = 10)
    private String jobId;
    @Column(name="JOB_TITLE", nullable = false, length = 35)
    private String jobTitle;
    @Column(name="MAX_SALARY")
    private int maxSalary;
    @Column(name="MIN_SALARY")
    private int minSalary;

    public Jobs() {
    }

    public Jobs(String jobId, String jobTitle, int maxSalary,
                int minSalary) {
        this.jobId = jobId;
        this.jobTitle = jobTitle;
        this.maxSalary = maxSalary;
        this.minSalary = minSalary;
    }

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobTitle() {
        return jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public int getMaxSalary() {
        return maxSalary;
    }

    public void setMaxSalary(int maxSalary) {
        this.maxSalary = maxSalary;
    }

    public int getMinSalary() {
        return minSalary;
    }

    public void setMinSalary(int minSalary) {
        this.minSalary = minSalary;
    }
}
