package adf.sample.ws.model.wrapper.bean;

import adf.sample.types.Departments;
import adf.sample.types.Employees;
import adf.sample.types.Jobs;
import adf.sample.types.Locations;
import adf.sample.ws.HumanResourcesWs;
import adf.sample.ws.HumanResourcesWs_Service;

import java.util.List;


public class WsPrxyWrapperBean {

    private static HumanResourcesWs_Service humanResourcesWsService = null;
    private static HumanResourcesWs wsport = null;

    public WsPrxyWrapperBean() {
        init();
    }

    private void init() {

        humanResourcesWsService = new HumanResourcesWs_Service();
        wsport = humanResourcesWsService.getHumanResourcesWsPort();
    }

    // query all departments */

    public List<Departments> getAllDepartments() {
        return wsport.getDepartmentsFindAll();
    }

    // query all departments /

    public List<Employees> getAllEmployees() {        
        return wsport.getEmployeesFindAll();
    }

    //get employees by department

    public List<Employees> getAllEmployeesForDepartment(Integer deptId) {
        return wsport.getEmployeesFindAllByDepartmentId(deptId);
    }

    //find department

    public List<Departments> getDepartment(Integer deptId) {
        return wsport.getDepartmentsFindAllById(deptId);
    }

    //get employee by employee id

    public List<Employees> getEmployeeById(Integer id) {
        return wsport.getEmployeesFindAllByEmployeeId(id);
    }

    //get all jobs

    public List<Jobs> getAllJobs() {
        return wsport.getJobsFindAll();
    }

    //get all locations

    public List<Locations> getAllLocations() {
        return wsport.getLocationsFindAll();
    }

    public void updateDepartment(Departments d) {
        Departments department = wsport.mergeDepartments(d);
    }

    public void removeDepartment(Departments d) {
        wsport.removeDepartments(d);
    }

    public void updateEmployees(Employees e) {
        Employees emp = wsport.mergeEmployees(e);
    }

    public void removeEmployee(Employees emp) {
        wsport.removeEmployees(emp);
    }
}
