package adf.sample.view.beans;

import oracle.adf.model.BindingContext;
import oracle.adf.model.bean.DCDataRow;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.view.rich.component.rich.data.RichTable;
import oracle.adf.view.rich.context.AdfFacesContext;
import oracle.adf.view.rich.event.DialogEvent;

import oracle.binding.OperationBinding;

public class DepartmentDialogBean {
    private RichTable table1;

    public DepartmentDialogBean() {
    }

    public void onDialogAction(DialogEvent dialogEvent) {
        DialogEvent.Outcome outcome = dialogEvent.getOutcome();
        if(outcome == DialogEvent.Outcome.ok){
          BindingContext bctx = BindingContext.getCurrent();
          DCBindingContainer bindings = (DCBindingContainer) bctx.getCurrentBindingsEntry();
          OperationBinding update = bindings.getOperationBinding("updateDepartment");
          update.execute();
          AdfFacesContext.getCurrentInstance().addPartialTarget(table1);
        }
        else{
          //ignore changes
          BindingContext bctx = BindingContext.getCurrent();
          DCBindingContainer bindings = (DCBindingContainer) bctx.getCurrentBindingsEntry();
          DCIteratorBinding iterator = bindings.findIteratorBinding("allDepartmentIterator");
          DCDataRow row = (DCDataRow)iterator.getCurrentRow();
          row.refresh(DCDataRow.REFRESH_UNDO_CHANGES);
        }
    }

    public void setTable1(RichTable table1) {
        this.table1 = table1;
    }

    public RichTable getTable1() {
        return table1;
    }
}
