package adf.sample;

import java.util.Iterator;
import java.util.List;

import oracle.adf.model.BindingContext;
import oracle.adf.view.rich.component.rich.data.RichTable;
import oracle.adf.view.rich.context.AdfFacesContext;

import oracle.binding.BindingContainer;
import oracle.binding.OperationBinding;

import oracle.jbo.Row;
import oracle.jbo.domain.Number;
import oracle.jbo.uicli.binding.JUCtrlHierNodeBinding;

import org.apache.myfaces.trinidad.event.SelectionEvent;
import org.apache.myfaces.trinidad.model.RowKeySet;


public class MasterDetailBean {
    private RichTable employeeTable;

    public MasterDetailBean() {
    }

    public void setEmployeeTable(RichTable employeeTable) {
        this.employeeTable = employeeTable;
    }

    public RichTable getEmployeeTable() {
        return employeeTable;
    }

    public void onDepartmentTableSelect(SelectionEvent selectionEvent) {
        //variable to hold the string containing all selected row's
        //departmentId value
        StringBuffer departmentIds = new StringBuffer();
        //get access to the master table to read selected row keys
        RichTable rt = (RichTable) selectionEvent.getSource();
        RowKeySet rks = rt.getSelectedRowKeys();
        Iterator selectedRowsIterator =  rks.iterator();
        //memorize the current row key to set it back at the end
        List currentRowKey = (List) rt.getRowKey();
        
        //for each selected master row, determine the departmentId
        while(selectedRowsIterator.hasNext()){
            List rowKey = (List) selectedRowsIterator.next();
            
            //each value is ended with a comma
            if(departmentIds.length() > 0){
              departmentIds.append(",");
            }
           
           //make the row current
           rt.setRowKey(rowKey);
           JUCtrlHierNodeBinding wrappedRow = (JUCtrlHierNodeBinding) rt.getRowData();
           Row rw = wrappedRow.getRow();
           Number departmentId = (Number) rw.getAttribute("DepartmentId");
           departmentIds.append(departmentId.stringValue());
        }
        
       //set row currency back
        rt.setRowKey(currentRowKey);
        
        //execute query on detail table
        BindingContext bctx = BindingContext.getCurrent();
        BindingContainer bindings = bctx.getCurrentBindingsEntry();
        OperationBinding executeWithParams =  bindings.getOperationBinding("ExecuteWithParams");
        executeWithParams.getParamsMap().put("departmentIds", departmentIds.toString());
        executeWithParams.execute();
        
        //refresh detail table
        AdfFacesContext adfFacesContext = AdfFacesContext.getCurrentInstance();
        adfFacesContext.addPartialTarget(employeeTable);

    }
}
