package adf.sample.view;

import javax.faces.context.FacesContext;

import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.share.ADFContext;
import oracle.adf.view.rich.component.rich.RichPopup;
import oracle.adf.view.rich.component.rich.data.RichTable;
import oracle.adf.view.rich.context.AdfFacesContext;
import oracle.adf.view.rich.event.DialogEvent;
import oracle.adf.view.rich.event.DialogEvent.Outcome;
import oracle.adf.view.rich.render.ClientEvent;

import oracle.binding.BindingContainer;
import oracle.binding.OperationBinding;

import oracle.jbo.Row;
import oracle.jbo.server.ViewRowImpl;


public class CreateDepartmentPageHelper {
    
    //old "current row" value is saved in view scope in case the rw creation is
    //cancelled, in which case this row needs to become current again
    final String OLD_CURR_KEY_VIEWSCOPE_ATTR = "__oldCurrentRowKey__";
    
    private RichPopup popup;
    private RichTable departmentsTable;

    public CreateDepartmentPageHelper() {
    }

    public void setPopup(RichPopup popup) {
        this.popup = popup;
    }

    public RichPopup getPopup() {
        return popup;
    }

    //system generated method when you create a managed bean method for 
    //a component that has an ADF binding referenced in its action listener
    public BindingContainer getBindings() {
        return BindingContext.getCurrent().getCurrentBindingsEntry();
    }

    //command action that create a new row in teh departments table and then
    //opens an edit dialog for commit/cancel
    public String cb1_action() {
       
        BindingContainer bindings = getBindings();
        
      
        //get current row and save its rowKey in view scope for later use
        DCIteratorBinding dciter = (DCIteratorBinding) bindings.get("allDepartmentsIterator");
        Row oldCcurrentRow = dciter.getCurrentRow();
        
        //ADFContext is a convenient way to access all kinds of memory scopes.
        //If you like to be persistent in yur ADF coding then this is what you 
        //want to use
        ADFContext adfCtx = ADFContext.getCurrent();
        adfCtx.getViewScope().put(OLD_CURR_KEY_VIEWSCOPE_ATTR, 
                                  oldCcurrentRow.getKey().toStringFormat(true));
        
        //perform row create
        OperationBinding operationBinding = bindings.getOperationBinding("CreateInsert");
        Object result = operationBinding.execute();
        if (!operationBinding.getErrors().isEmpty()) {
            return null;
        }
        
        //access the popup dialog and bring it up. The reference is through a 
        //JSF component binding reference using the popup "binding" property
        RichPopup popup = this.getPopup();
        RichPopup.PopupHints hints = new RichPopup.PopupHints();
        //empty hints renders dialog in center of screen
        popup.show(hints);        
        return null;
    }

    public void onDialogAction(DialogEvent dialogEvent) {
        Outcome outcome = dialogEvent.getOutcome();
        
        //the dialog event only propagates yes, no, ok actions to the 
        //server. The cancel outcome is only available on the browser 
        //client. If there is a need to handle the cancel even then you
        //need to use a clientListener and JavaScript as we do on this 
        //example
        if(outcome == Outcome.ok){
            //commit
            BindingContainer bindings = getBindings();
            OperationBinding operationBinding = bindings.getOperationBinding("Commit");
            Object result = operationBinding.execute();
            if (!operationBinding.getErrors().isEmpty()) {
                //handle errors if any
                //...
                return;
            }                                
            AdfFacesContext.getCurrentInstance().addPartialTarget(this.getDepartmentsTable());
        }
    }

    public void setDepartmentsTable(RichTable departmentsTable) {
        this.departmentsTable = departmentsTable;
    }

    public RichTable getDepartmentsTable() {
        return departmentsTable;
    }

    //method that is called from the serverListener on the client. The server 
    //listener is used to queue a custom event and pass information from the
    //client to the server using JavaScript. Its actually doing this Ajax thing
    //that everyone wants to do using the XmlHTTPRequest object
    public void onDialogCancel(ClientEvent clientEvent) {
      BindingContainer bindings = getBindings();
               
      RichPopup popup = this.getPopup();
      popup.hide();      
      
      //the cancel operation is executed with immediate=true to bypass the 
      //model update. Therefore we manually deletethe new row from the iterator
      DCIteratorBinding dciter = (DCIteratorBinding) bindings.get("allDepartmentsIterator");      
      Row currentRow = dciter.getCurrentRow();                          
      dciter.removeCurrentRow();
            
      //set current row back to original row
      ADFContext adfCtx = ADFContext.getCurrent();
      
      String oldCurrentRowKey = (String) adfCtx.getViewScope().get(OLD_CURR_KEY_VIEWSCOPE_ATTR);
      dciter.setCurrentRowWithKey(oldCurrentRowKey);
      
      AdfFacesContext.getCurrentInstance().addPartialTarget(this.getDepartmentsTable()); 
      FacesContext  fctx = FacesContext.getCurrentInstance();
      //we don't want to continue with the remainder of the lifecycle and 
      //thus skip the rest
      fctx.renderResponse();
    }
  
}
