package adf.sample.view;

import java.util.ArrayList;
import java.util.List;

import javax.el.ELContext;
import javax.el.ExpressionFactory;

import javax.faces.context.FacesContext;

import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.view.rich.component.rich.layout.RichShowDetailItem;

import oracle.binding.BindingContainer;

import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.uicli.binding.JUCtrlHierBinding;
import oracle.jbo.uicli.binding.JUCtrlHierNodeBinding;

import org.apache.myfaces.trinidad.event.DisclosureEvent;


public class GraphBean {

    FacesContext fctx = FacesContext.getCurrentInstance();
    ELContext elctx = fctx.getELContext();
    ExpressionFactory expressionFactory = fctx.getApplication().getExpressionFactory();

    public GraphBean() {
        super();
    }

    public void onTabDisclosure(DisclosureEvent disclosureEvent) {       
        RichShowDetailItem tab = (RichShowDetailItem) disclosureEvent.getSource();        
        if (tab.isDisclosed()) {
            List key = (List)tab.getAttributes().get("rowKey");
            JUCtrlHierBinding treeBinding = this.getTreeBinding();
            JUCtrlHierNodeBinding currentNode = treeBinding.findNodeByKeyPath(key);
            makeCurrent(currentNode);
        }
    }
    
  /*
       * Make row current in underlying iterator
       */
      private void makeCurrent(JUCtrlHierNodeBinding node){
        //get the key of the row represented 
        //by the node binding
        Row rw = node.getRow();  
        Key key = rw.getKey();
        //make this row the current row in the binding layer
        //so master/detail behavior works correctly
        JUCtrlHierBinding treeBinding = this.getTreeBinding();        
        DCIteratorBinding iterator = treeBinding.getDCIteratorBinding();
        iterator.setCurrentRowWithKey(key.toStringFormat(true));          
      }
      
    private JUCtrlHierBinding getTreeBinding(){
      BindingContext bctx = BindingContext.getCurrent();
      BindingContainer bindings = bctx.getCurrentBindingsEntry();
      JUCtrlHierBinding treeBinding = (JUCtrlHierBinding) bindings.get("allDepartmentsWithEmployees");
      return treeBinding;
    }
}
