package adf.sample.view.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;

import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

import oracle.adf.view.rich.component.rich.data.RichTreeTable;
import oracle.adf.view.rich.context.AdfFacesContext;

import oracle.jbo.uicli.binding.JUCtrlHierBinding;
import oracle.jbo.uicli.binding.JUCtrlHierNodeBinding;
import oracle.jbo.uicli.binding.JUCtrlHierTypeBinding;

import org.apache.myfaces.trinidad.event.RowDisclosureEvent;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.RowKeySet;


public class BrowseLocDeptEmpBean {
    
    //HashMap that holds the column names of each tree level in a string array. 
    //The Map key is the StructureDefName of the node, which is the class name
    //and package name of the object reppresenting the node
    private HashMap nodeAttributes = null;
    
    
    public BrowseLocDeptEmpBean() { }
    
    //listen to teh tree table disclosure
    public void onNodeDisclosure(RowDisclosureEvent rowDisclosureEvent) {
    
        String nodeDefName = null;
        
        JUCtrlHierNodeBinding disclosedNode = null;
        //the typBinding is the ADF hierarchical tree binding node structure. We
        //use this information to determine, which node's columns must be shown 
        //and which node's columns must be hidden
        JUCtrlHierTypeBinding typeBinding[] = null;
        
        //the handling of a node close event is different the disclosure of a 
        //node. If the event's addedSet is empty then we know a node is closed.
        //If the addedSet has content, then a node has been discloed
        boolean isCloseEvent = false;
        //get access to the RichTreeTable instance. To have this code generic, we 
        //use the event object as a starting point to the tree table component 
        //and the ADF hierarchical tree binding
        RichTreeTable treeTable = (RichTreeTable)rowDisclosureEvent.getSource();
        CollectionModel model = (CollectionModel)treeTable.getValue();
        JUCtrlHierBinding treeBinding = (JUCtrlHierBinding)model.getWrappedData();
                    
        //query a list of tree nodes and node attributes. Do this only once per
        //managed bean instantiation (viewScope) as it is assumed that the tree
        //structure does not change at runtime. 
        if(nodeAttributes == null){
            
            nodeAttributes = new HashMap();
            typeBinding = treeBinding.getTypeBindings();
            //get the attributes for each node level. Note that this also
            //find node attribute that are not displayed in the tree table. 
            //However, the way this sample implements the show/hide function
            //does not require to check for a node's attribute to be visible
            //in the tree as there is no risk for a NPE
            for (int i = 0; i < typeBinding.length; i++) {
                String[] attributeNames = typeBinding[i].getAttrNames();
                String nodeObjectTypeName = typeBinding[i].getStructureDefName();           
                nodeAttributes.put(nodeObjectTypeName, attributeNames);
            }
        }

        //get the disclosed node
        RowKeySet rowKeySet = rowDisclosureEvent.getAddedSet();

        //did disclosure event open a new node ?        
        if(rowKeySet.iterator().hasNext()){
            isCloseEvent = false;
        }
        else{
            isCloseEvent = true;
            rowKeySet = rowDisclosureEvent.getRemovedSet();
        }
                        
        Iterator iterator = rowKeySet.iterator();
        
        if (iterator.hasNext()) {
            List rowKey = (List)iterator.next();
            disclosedNode = treeBinding.findNodeByKeyPath(rowKey);
                                                
            //determine the node the user selected. We determine this by the
            //Object that represnets the node, which is the full package and
            //class name of the View Object
            JUCtrlHierTypeBinding nodeType = disclosedNode.getHierTypeBinding();                        
            nodeDefName =  nodeType.getStructureDefName();        
        }            
            
            //the logic in the following is as follows:
            //1.  We need to show all the columns of the children that belong to 
            //    the disclosed node. If we disclose Locations, then we need to 
            //    show the columns for Departments. 
            // 2. So what we do is that we check for a match of the disclosed 
            //    node's StructureDef name with one of the StructureNodeDefNames 
            //    we found in the ADF HierarchicalTree. If we find a match then
            //    we know that the immediate child columns must be shown and the
            //    all the other child nodes below must be hidden
            // 3. We use "matchingNodeFound" and "directChildNodeHandled" to 
            //    determine if the disclosed node was found and if the immediate
            //    child was handled (displayed its columns)
            // 4. The code updates the managed bean that holds teh visible state
            //    of the tree table columns and then refresh the parent of the 
            //    tree table
            boolean matchingNodeFound = false;
            boolean directChildNodeHandled = false;
            for (int i = 0; i < typeBinding.length; i++) {
              if(matchingNodeFound == true && directChildNodeHandled == false){
                String childNodeToShowHide = typeBinding[i].getStructureDefName();
                //get node column attributes from binding layer
                String[] columnAttributes = (String[]) nodeAttributes.get(childNodeToShowHide);
                for (int colIndex = 0; colIndex < columnAttributes.length; colIndex++) {
                  this.getTreeTableStateObject().put(columnAttributes[colIndex], isCloseEvent == true ? "false" : "true");
                }  
              directChildNodeHandled = true;
            }
            else if(matchingNodeFound == true && directChildNodeHandled == true){                   
              String childNodeToShowHide = typeBinding[i].getStructureDefName();
              //get node column attributes from binding layer
              String[] columnAttributes = (String[]) nodeAttributes.get(childNodeToShowHide);
              for (int colIndex = 0; colIndex < columnAttributes.length; colIndex++) {
                this.getTreeTableStateObject().put(columnAttributes[colIndex], "false");
              } 
            }
                    
            //ensure to first search for a matching tree node definition          
            if (nodeDefName.equalsIgnoreCase(typeBinding[i].getStructureDefName())){
              //ensure close and disclose is applied to the child items of the 
              //disclosed node
              matchingNodeFound = true;
            }
            //make sure only the selected row key set is disclosed and the rest
            //is closed. This use case will become quite complex if we allow
            //multiple disclosed nodes. So for this level, we have a parent node
            //to find        
            if (isCloseEvent == false && disclosedNode.getParent() != null 
                      && !disclosedNode.getParent().getKeyPath().isEmpty()){
                  rowKeySet.add(disclosedNode.getParent().getKeyPath());
             }

             if (isCloseEvent == false) {
                 treeTable.setDisclosedRowKeys(rowKeySet);
             }
         }                           
          partiallyRefreshUIComponent("pc1");
    } 
    
    /* ******************************************************************
      * PRIVATE METHODS
      * *****************************************************************/

       
      private TreeTableStateBean getTreeTableStateObject(){
        TreeTableStateBean stateBean = null;
        
        FacesContext fctx = FacesContext.getCurrentInstance();
        ELContext elctx = fctx.getELContext();
        ExpressionFactory elFactory = fctx.getApplication().getExpressionFactory();
        
        ValueExpression ve = elFactory.createValueExpression(
                                elctx, 
                                "#{viewScope.treeTableStateBean}", 
                                Object.class);
        
        stateBean = (TreeTableStateBean) ve.getValue(elctx);        
        return stateBean;
      }
      
       //refreshes component by passed on component id. Be aware of naming containers!
       //Components in a naming container must have a prefix "<namingContainerId>:"
       private void partiallyRefreshUIComponent(String uid) {
           FacesContext fctx = FacesContext.getCurrentInstance();
           UIViewRoot viewRoot = fctx.getViewRoot();
           UIComponent component = viewRoot.findComponent(uid);
           partiallyRefreshUIComponent(component);
       }

       private void partiallyRefreshUIComponent(UIComponent component) {
           AdfFacesContext adfFacesContext = AdfFacesContext.getCurrentInstance();
           if (component != null) {
               adfFacesContext.addPartialTarget(component);
           }
       }
}
