package adf.sample.view.beans;

import java.util.HashMap;

import org.apache.myfaces.trinidad.event.RowDisclosureEvent;

public class TreeTableStateBean extends HashMap{
    private static final long serialVersionUID = 0L;

    public TreeTableStateBean() {
        super();
    }
    
    /**
     * The HashMap returns TRUE / FALSE for the keys passed in. The bean is used
     * as a managed bean and referenced from the TreeTable column display property.
     * It allows to dynamically show/hide a tree table columns based on the node
     * selection.      
     * @param key
     * @return
     */
    @Override
    public Boolean get(Object key) {
        if(super.get(key)==null){
            return Boolean.FALSE;
        }
        else{
            try {
                String colStateString = (String) super.get(key);
                Boolean colState = Boolean.parseBoolean(colStateString);
                return colState;
            } catch (Exception e) {
                //cannot parse value String, thus return false
                return Boolean.FALSE;                
            }
        }
    }
}
