package adf.sample.view.beans;

import oracle.adf.model.BindingContext;

import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.view.rich.component.rich.RichPopup;
import oracle.adf.view.rich.component.rich.layout.RichPanelFormLayout;

import oracle.adf.view.rich.context.AdfFacesContext;

import oracle.binding.BindingContainer;
import oracle.binding.OperationBinding;

public class ComoboxBean {
    private RichPanelFormLayout inputFormLayoutPanel;
    private RichPopup createDepartmentPopup;

    public ComoboxBean() {
    }

    public String createNewEntry() {
        BindingContainer bindings = this.getBindings();
        OperationBinding commit = (OperationBinding) bindings.get("Commit");
        //adding a list option only makes sense if the change is 
        //committed
        commit.execute();
        //refresh form so list is updated in view
        AdfFacesContext adfFacesCtx = AdfFacesContext.getCurrentInstance();
        adfFacesCtx.addPartialTarget(inputFormLayoutPanel);
        return null;
    }

    public String cancelCreation() {
        BindingContainer bindings = this.getBindings();
        DCIteratorBinding dciterator = (DCIteratorBinding) bindings.get("DepartmentsView1Iterator");
        dciterator.getCurrentRow().remove();        
        return null;
    }
    
    private BindingContainer getBindings(){
      BindingContext bctx = BindingContext.getCurrent();
      BindingContainer bindings = bctx.getCurrentBindingsEntry();
      return bindings;
    }

    public void setInputFormLayoutPanel(RichPanelFormLayout inputFormLayoutPanel) {
        this.inputFormLayoutPanel = inputFormLayoutPanel;
    }

    public RichPanelFormLayout getInputFormLayoutPanel() {
        return inputFormLayoutPanel;
    }

    public String onCreateNewDepartment() {
        BindingContainer bindings = this.getBindings();
        OperationBinding create = (OperationBinding) bindings.get("Create");
        create.execute();
        //bring up the popup
        RichPopup.PopupHints hints = new RichPopup.PopupHints();
        createDepartmentPopup.show(hints);
        return null;
    }

    public void setCreateDepartmentPopup(RichPopup createDepartmentPopup) {
        this.createDepartmentPopup = createDepartmentPopup;
    }

    public RichPopup getCreateDepartmentPopup() {
        return createDepartmentPopup;
    }
}
