package adf.sample.service.wrapper;


import adf.sample.model.jpa.AllEmployeesBean;
import adf.sample.model.jpa.AllEmployeesBeanService;
import adf.sample.model.jpa.Employees;

import java.util.ArrayList;
import java.util.List;

/**
 * Java Bean that is exposed as a data control. The bean accesses the
 * JAX-WS proxy client to expose methods of the Web Service
*/
public class AllEmployeesServiceWrapperBean {
	//Web Service roxy client class
    AllEmployeesBean allEmployeesBean = null;
    AllEmployeesBeanService allEmployeesBeanService = null;
    //List object for caching
    List<Employees> employeesCache = null;
    List<Employees> employeesRet = null;
    final int VALUE_MATCH = 0;

    public AllEmployeesServiceWrapperBean() {
        super();
        //connect to the proxy client
        allEmployeesBeanService = new AllEmployeesBeanService();
        allEmployeesBean = allEmployeesBeanService.getAllEmployeesBeanService();
    }

    //query all employees. This method is called when the ADF table
    //executes its underlying iterator
    public List<Employees> getAllEmployees(){
        if(employeesCache == null){
            employeesCache = allEmployeesBean.getEmployeesFindAll();
            employeesRet = employeesCache;
        }
        else if(employeesRet == null){
            employeesRet = employeesCache;
        }
      return employeesRet;
    }

    //To some point, you may want to re-execute the service to get the latest data.
    //In this case, the cache List is set to null.
    public void clearProxyCache(){
        employeesCache = null;
    }

    //to filter the data displayed in the table, an extra method is exposed on the POJO
    //and thus the Data Control. Instead of querying the Web Service, this method operates
    //on the cached data
    public void filterEmployeesByDepartmentId(Long departmentId){
        employeesRet = new ArrayList<Employees>();
        if(departmentId == null){
            employeesRet = employeesCache;
            return;
        }

        for(Employees emp : employeesCache){
            if(emp.getDepartmentId() != null &&
               emp.getDepartmentId().compareTo(departmentId)== VALUE_MATCH){
                employeesRet.add(emp);
            }
        }
    }
}
