package adf.sample.model.jpa;

import java.util.List;


import javax.jws.Oneway;

import javax.jws.WebMethod;
import javax.jws.WebService;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;


@WebService(portName = "AllEmployeesBeanService")
public class AllEmployeesBean implements AllEmployees, AllEmployeesLocal {
    @PersistenceContext(unitName="Model")
    private EntityManager em;

    public AllEmployeesBean() {
    }

    @WebMethod
    public Employees persistEmployees(Employees employees) {
        em.persist(employees);
        return employees;
    }

    @WebMethod
    public Employees mergeEmployees(Employees employees) {
        return em.merge(employees);
    }

    @Oneway
    @WebMethod
    public void removeEmployees(Employees employees) {
        employees = em.find(Employees.class, employees.getEmployeeId());
        em.remove(employees);
    }

    @WebMethod
    public List<Employees> getEmployeesFindAll() {
        return em.createNamedQuery("Employees.findAll").getResultList();
    }
}
