package adf.sample.model.jpa;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@NamedQueries({
  @NamedQuery(name = "Employees.findAll", query = "select o from Employees o")
})
public class Employees implements Serializable {
    @SuppressWarnings("compatibility")
    private static final long serialVersionUID = 443509989117730054L;
    @Column(name="COMMISSION_PCT")
    private Double commissionPct;
    @Column(name="DEPARTMENT_ID")
    private Long departmentId = null;
    @Column(nullable = false, unique = true, length = 25)
    private String email = null;
    @Id
    @Column(name="EMPLOYEE_ID", nullable = false)
    private Long employeeId = null;
    @Column(name="FIRST_NAME", length = 20)
    private String firstName = null;
    @Column(name="HIRE_DATE", nullable = false)
    @Temporal(value = TemporalType.DATE)
    private Date hireDate = null;
    @Column(name="JOB_ID", nullable = false, length = 10)
    private String jobId = null;
    @Column(name="LAST_NAME", nullable = false, length = 25)
    private String lastName = null;
    @Column(name="PHONE_NUMBER", length = 20)
    private String phoneNumber = null;
    private Double salary = null;

    public Employees() {
    }

    public Employees(Double commissionPct,
                     Long departmentId,
                     String email,
                     Long employeeId,
                     String firstName,
                     Date hireDate,
                     String jobId,
                     String lastName,
                     String phoneNumber,
                     Double salary) {
        this.commissionPct = commissionPct;
        this.departmentId = departmentId;
        this.email = email;
        this.employeeId = employeeId;
        this.firstName = firstName;
        this.hireDate = hireDate;
        this.jobId = jobId;
        this.lastName = lastName;
        this.phoneNumber = phoneNumber;
        this.salary = salary;
    }

    public Double getCommissionPct() {
        return commissionPct;
    }

    public void setCommissionPct(Double commissionPct) {
        this.commissionPct = commissionPct;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Date getHireDate() {
        return hireDate;
    }

    public void setHireDate(Date hireDate) {
        this.hireDate = hireDate;
    }

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }


    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Double getSalary() {
        return salary;
    }

    public void setSalary(Double salary) {
        this.salary = salary;
    }
}
