package adf.sample.task.flows.retexit;


import adf.sample.shared.context.SharedContext;

import java.util.Map;

import oracle.adf.model.BindingContext;
import oracle.adf.share.ADFContext;

import oracle.binding.AttributeBinding;
import oracle.binding.BindingContainer;


public class CreateDepartmentBacking {
    public CreateDepartmentBacking() {
    }

    //When the commit button is pressed, read the new roe's department Id value 
    //and return it to the calling task flow (parent flow)
    public String onCommit() {
        ADFContext adfctx = ADFContext.getCurrent();
        Map<String, Object> flowScope = adfctx.getPageFlowScope();
        
        /* its safe to assume that the managed bean is intantiated and that it
         * exists in memory because it is referenced from the task flow input 
         * parameters upon task flow start. The managed bean is defined in the 
         * task flow definition
         *
         * Note that if you cannot be sure a managed bean exists in memory, it is better 
         * to use EL to access it so that JSF can create an instance of the bean, avoiding 
         * a NPE
         */
        
         SharedContext sharedSampleContext = (SharedContext) flowScope.get("sharedTaskFlowContext");        
    
        BindingContext bctx = BindingContext.getCurrent();
        BindingContainer bindings = bctx.getCurrentBindingsEntry();
        AttributeBinding deptId = (AttributeBinding) bindings.get("DepartmentId");                
        //Save department Id value as return value
        sharedSampleContext.getCurrentInstance().setReturnValue(deptId.getInputValue());
        
        return "returnCommit";
    }
}
