package adf.sample.view.beans;


import adf.sample.shared.context.SharedContextImpl;
import adf.sample.view.backing.BrowseEditBackingBean;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;

import javax.faces.context.FacesContext;

import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.view.rich.component.rich.RichPopup;
import oracle.adf.view.rich.context.AdfFacesContext;
import oracle.adf.view.rich.event.RegionNavigationEvent;

import oracle.binding.BindingContainer;

import oracle.jbo.Key;
import oracle.jbo.Row;


public class RegionSwitcherBean {
    private String taskFlowId = "/WEB-INF/retExitRegionBtf/md-return-exit-region-btf.xml#md-return-exit-region-btf";
    private String emptyTaskFlow = "";
    private String currentTaskFlow = emptyTaskFlow;
    
    public RegionSwitcherBean() {
    }

    //referenced by dynamic region
    public String getDynamicTaskFlowId() {
        return currentTaskFlow;
    }
    
    //method to switch region to empty task flow
    public String switchTaskFlowToEmptyString(){
        currentTaskFlow = emptyTaskFlow;
        return null;
    }

    //method to switch task flow to create department region
    public String switchTaskFlowToCreateDepartment(){
        currentTaskFlow = taskFlowId;
        return null;
    }

    public void onRegionNavigation(RegionNavigationEvent regionNavigationEvent) {
        //check if task flow as region is exited, in which 
        //case the view id is null
        if(regionNavigationEvent.getNewViewId() == null){
            currentTaskFlow = emptyTaskFlow;
            //check if exit was on commit or rollback
            FacesContext fctx = FacesContext.getCurrentInstance();
            ELContext elctx = fctx.getELContext();
            ExpressionFactory exprFactory = fctx.getApplication().getExpressionFactory();
            ValueExpression ve = exprFactory.createValueExpression(elctx, "#{viewScope.sharedTaskflowContext}", Object.class);
            SharedContextImpl sharedCtx = (SharedContextImpl) ve.getValue(elctx);
            
            if(sharedCtx != null){
                boolean commit = sharedCtx.getExitIsCommit();
                if(commit==true){
                    //set new row to become current and refresh table
                    BindingContainer bindings = BindingContext.getCurrent().getCurrentBindingsEntry();
                    DCIteratorBinding dciter = (DCIteratorBinding) bindings.get("allDepartmentsIterator");
                    dciter.executeQuery();
                     //get the return value
                     Object retValue = sharedCtx.getReturnValue();
                         if(retValue != null){
                            //make new row current 
                            Key k = new Key(new Object[]{(Integer) retValue});
                            Row rw = dciter.getRowSetIterator().getRow(k);                            
                            dciter.getRowSetIterator().setCurrentRow(rw);
                            
                            //lookup table component instance using managed bean reference
                            ve = exprFactory.createValueExpression(elctx, "#{BrowseEditBackingBean}", Object.class);
                            BrowseEditBackingBean browseEditBackingBean = (BrowseEditBackingBean) ve.getValue(elctx);
                            
                            //refresh table
                            AdfFacesContext adfFacesCtx = AdfFacesContext.getCurrentInstance();
                            adfFacesCtx.addPartialTarget(browseEditBackingBean.getDepartmentsTable()); 
                            
                            //launch dialog to edit newly created record
                            RichPopup popup = browseEditBackingBean.getEditDialog();
                            RichPopup.PopupHints hints = new RichPopup.PopupHints();
                            popup.show(hints);
                            
                    }
                         else{
                             System.out.println("LOG: No return value found");
                         }
                }
                else{
                    //nothing to do
                }
            }
            else{
                System.out.println("LOG: Shared Context is NULL");
            }
        }
    }
}
