package adf.sample.shared.context;

import java.util.HashMap;


/**
 * Shared Context class extending Hashmap. All shared information is exposed
 * through public methods but saved in the HashMap. Developers are able to
 * pass addition information to a task flow by directly calling put / get on
 * the context class.
 */
public class SharedContextImpl extends HashMap{
    @SuppressWarnings("compatibility")
    private static final long serialVersionUID = -2047438954870030787L;

    final String RETURN_VALUE = "___returnValue_____";
    final String COMMIT_INDICATOR = "___commitIndicator_____";
    
    Boolean exitIsCommit = false;

    public SharedContextImpl() {
        super();
        this.put(RETURN_VALUE, null);
        this.put(COMMIT_INDICATOR, exitIsCommit);
    }


    public void setExitIsCommit(Boolean exitIsCommit) {
        this.put(COMMIT_INDICATOR, exitIsCommit);
    }

    public Boolean getExitIsCommit() {
        return (Boolean) this.get(COMMIT_INDICATOR);
    }


    public void setReturnValue(Object returnValue) {
        this.put(RETURN_VALUE, returnValue);
    }

    public Object getReturnValue() {
        return this.get(RETURN_VALUE);
    }


    public void setCommittedonExitTrue(){
        this.put(COMMIT_INDICATOR, Boolean.TRUE);
    }

    public void setCommittedonExitFalse(){
        this.put(COMMIT_INDICATOR, Boolean.FALSE);
    }

}
