package adf.sample;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.PhaseId;

import oracle.adf.controller.TaskFlowTrainStopModel;
import oracle.adf.view.rich.component.rich.RichPopup;
import oracle.adf.view.rich.component.rich.fragment.RichPageTemplate;
import oracle.adf.view.rich.component.rich.fragment.RichRegion;
import oracle.adf.view.rich.component.rich.nav.RichCommandNavigationItem;
import oracle.adf.view.rich.event.DialogEvent;


public class TrainHandlerBean {
    /**
     * Managed bean property reference to a helper bean in view scope
     */
    private TrainHandlerBeanHelper trainHandlerBeanHelper = null;


    public TrainHandlerBean() {
    }

    /**
     * Action method that is referenced from the train stop command action to defer train navigation 
     * and allow developers to interact with the user. In this sample a popup  dislog is opened for the 
     * user to confirm train navigation. 
     * 
     * The use case for deferred trainstop navigation includes manual complex field validation, to check for
     * uncommitted data, e.g. ControllerContext.getInstance().getCurrentViewPort().isDataDirty() , etc. 
     * 
     * @param actionEvent
     */
    
    public void onTrainStopSelect(ActionEvent actionEvent) {
        RichCommandNavigationItem rni = (RichCommandNavigationItem)actionEvent.getSource();
        TaskFlowTrainStopModel selectedTrainStop = (TaskFlowTrainStopModel)rni.getAttributes().get("trainStopNode");
        String outcome = selectedTrainStop.getOutcome();
        trainHandlerBeanHelper.setSelectedTrainStopOutcome(outcome);
        

        /*
         * ADD YOUR DEFERRED ACTION. FOR EXAMPLE, LAUNCH POPUP. TO CONTINUE THE TRAIN
         * NAVIGATION, CALL queueTrainStopEventToRegion( ... )
         */

        //launch popup. Start search from af:region. The af:region and the af:pageTemplate tags are
        //naming container. This has an impact to the runtime ID of the popup component. So to find 
        //popup component just by its ID "pt_p1", we enter the region container, then the template to 
        //then call findComponent("pt_p1")
        RichRegion adfRegion = this.findRichRegionContainer(rni);        
        
        // in this sample, the popup component is in a template. Page Fragments can only have a single 
        //root component (everythiung else is flagged as an error) so that the template must be the first
        //children in the region
        
        RichPageTemplate regionTrainstopPopupTemplate = null;
        regionTrainstopPopupTemplate = (RichPageTemplate) adfRegion.getChildren().get(0);
        UIComponent component = regionTrainstopPopupTemplate.findComponent("pt_p1");
        
        if(component != null){
            RichPopup richPopup = (RichPopup) component;
            //align popup to screen center
            RichPopup.PopupHints hints = new  RichPopup.PopupHints();
            richPopup.show(hints);
        }
        else{
            //TODO change to use logger
            System.out.println("The popup instance with ID pt_p1 could not be found");
        }
    }

    /**
     * Method that finds the af:region container for a bounded task flow
     * exposed in a region. Don't use this method outside of ADF regions.
     * @param uiComponent Component within the region that is the starting 
     *        point for the search
     * @return The RichRegion instance as UIComponent
     */
    private RichRegion findRichRegionContainer(UIComponent uiComponent) {
        UIComponent currentComponent = uiComponent;
        while(!(currentComponent instanceof RichRegion)){
            //task flows in a region always have a RichRegion container
            //sonewhere. 
            currentComponent = currentComponent.getParent();
        }
        return (RichRegion) currentComponent;
    }

   /**
     * In this sample the popp contains a dialog with OK, Cancel button. When OK is clicked, the
     * train stop navigation should progress. If not, the train stop should not continue and remain
     * on the current page
     * 
     * @param dialogEvent
     */
    public void onDialogAction(DialogEvent dialogEvent) {
        //only if user cofirmed navigation to the next train stop,
        //perform navigation. Otherwise ignore request and remain
        //on current train stop view
        if (dialogEvent.getOutcome() == DialogEvent.Outcome.ok) {
            //perform saved train stop navigation
            queueTrainStopEventToRegion("#{viewScope.TrainHandlerBeanHelper.getSelectedTrainStopOutcome}",
                                        dialogEvent.getComponent());
        }
    }

    /**
     * Wrapper method around the RichRegion queueActionEventInRegion API.
     * @param outcomeEL The EL to access a managed bean that returns the navigation string to 
     *        to follow. This can be a outcome for a navigation case, or as in this sample, the 
     *        implicit navigation case used in trains
     *        
     * @param searchComponentInRegion To queue the action, we need a handle to the RichRegion 
     *        component. Providing us with a component residing in a region is all that is 
     *        needed to search the af:region container
     */
    private void queueTrainStopEventToRegion(String outcomeEL, UIComponent searchComponentInRegion) {
        //This sample assmumes bounded task flows to be exposed in an af:region. So it is save to
        //assume a parent component to be of type RichRegion. Lets find it to queue the train stop
        //outcome event for navigation.
        RichRegion adfRegion = null;

        adfRegion = this.findRichRegionContainer(searchComponentInRegion);

        FacesContext fctx = FacesContext.getCurrentInstance();
        ExpressionFactory expressionFactory = fctx.getApplication().getExpressionFactory();
        ELContext elctx = fctx.getELContext();
        MethodExpression methodExpression =
            expressionFactory.createMethodExpression(elctx,outcomeEL, String.class,
                                                     new Class[] { });
        //queue action in region
        adfRegion.queueActionEventInRegion(methodExpression, null, null, false, 0, 0, PhaseId.INVOKE_APPLICATION);
    }


    /**
     * Managed bean property reference to a managed bean in view scope
     * @param trainHandlerBeanHelper Managed bean inserted as a managed property reference
     */
    public void setTrainHandlerBeanHelper(TrainHandlerBeanHelper trainHandlerBeanHelper) {
        this.trainHandlerBeanHelper = trainHandlerBeanHelper;
    }

    public TrainHandlerBeanHelper getTrainHandlerBeanHelper() {
        return trainHandlerBeanHelper;
    }

}
