package adf.sample.bean;

import java.util.ArrayList;
import java.util.Map;

import javax.el.ELContext;
import javax.el.ExpressionFactory;

import javax.el.MethodExpression;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;

import oracle.adf.view.rich.event.QueryEvent;
import oracle.adf.view.rich.model.FilterableQueryDescriptor;

import oracle.jbo.domain.Number;

public class EmployeesBackingBean {
    public EmployeesBackingBean() {
    }

    public void onEmployeeTableQuery(QueryEvent queryEvent) {
        //user selected values
        ArrayList<Object> departmentIdArray = null;        
        FilterableQueryDescriptor fqd = (FilterableQueryDescriptor) queryEvent.getDescriptor();
        
        //current criteria
        Map _criteriaMap = fqd.getFilterCriteria();
        
        //Translate DepartmentId array list to OR separate list of values        
        StringBuffer deptIdFilterString = new StringBuffer(); 
        if (_criteriaMap.get("DepartmentId")!=null){
           departmentIdArray = (ArrayList<Object> )_criteriaMap.get("DepartmentId");
           
           for (int argIndex = 0; argIndex < departmentIdArray.size(); argIndex++) {
               
                //You need to know what is the underlying data type you are dealing 
                //with for the attribute. If you are on 11gR1 (11.1.1.x) then this
                //type is jbo.domain.Number for numeric attributes. 
                //
                //If you are on 11g R2 (11.1.2.x) this could be oracle.jbo.domain.Number, 
                //Integer or BigDecimal. If you use 11g R2, check the View Object for the
                //attribute data type
               
               if(argIndex == 0){
                   //first argument has no OR 
               
                   //this sample used oracle.jbo.domain.Number for the 
                   //DepartmentId attribute
                   Number departmentId = (Number) departmentIdArray.get(argIndex);
                   deptIdFilterString.append(departmentId.toString());                   
               }
               else{
                   //any subsequent argument is OR'ed together
                   deptIdFilterString.append(" OR ");   
                   Number departmentId = (Number) departmentIdArray.get(argIndex);
                   deptIdFilterString.append(departmentId.toString());  
              }
            }
           //for some reasons, if in a single value select case, the 
           //filter breaks and an error message is printed that the
           //String representation of the single value isn't found in
           //the list. The line below fixes the problem for filter values
           //that are positive numbers
           deptIdFilterString.append(" OR -1");   
           String departmentIds = deptIdFilterString.toString();
           _criteriaMap.put("DepartmentId", departmentIds);
           fqd.setFilterCriteria(_criteriaMap);               
        }


        // preserve default query listener behavior
        //#{bindings.allEmployeesQuery.processQuery}
        
        FacesContext fctx = FacesContext.getCurrentInstance();
        Application application = fctx.getApplication();
        ExpressionFactory expressionFactory = application.getExpressionFactory();
        ELContext elctx = fctx.getELContext();
        
        MethodExpression methodExpression = expressionFactory.createMethodExpression(
                                      elctx,
                                      "#{bindings.allEmployeesQuery.processQuery}",
                                      Object.class,
                                      new Class[] {QueryEvent.class});
        methodExpression.invoke(elctx, new Object[]{queryEvent});
        
        //restore filter selection done by the user. Note that this 
        //needs to be saved as an ArrayList
        _criteriaMap.put("DepartmentId", departmentIdArray);
        fqd.setFilterCriteria(_criteriaMap);
    }
}
